/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.protege.editor.core.ui.preferences.PreferencesPanelLayoutManager;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.ontology.OntologyPreferences;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;

public class OntologyPreferencesPanel
extends OWLPreferencesPanel {
    private static final Logger logger = Logger.getLogger(OntologyPreferencesPanel.class);
    private JTextField textField;
    private JCheckBox yearCheckBox;
    private JCheckBox monthCheckBox;
    private JCheckBox dayCheckBox;
    private JTextComponent previewLabel;

    public void applyChanges() {
        OntologyPreferences prefs = OntologyPreferences.getInstance();
        try {
            prefs.setBaseURI(new URI(this.textField.getText()));
            prefs.setIncludeYear(this.yearCheckBox.isSelected());
            prefs.setIncludeMonth(this.monthCheckBox.isSelected());
            prefs.setIncludeDay(this.dayCheckBox.isSelected());
        }
        catch (URISyntaxException e) {
            UIHelper uiHelper = new UIHelper(this.getOWLEditorKit());
            uiHelper.showOptionPane("Error", "Couldn't set base URI: " + e.getMessage(), 0, 0);
        }
    }

    public void initialise() throws Exception {
        OntologyPreferences prefs = OntologyPreferences.getInstance();
        this.setLayout((LayoutManager)new PreferencesPanelLayoutManager((JComponent)((Object)this)));
        this.textField = new JTextField(prefs.getBaseURI().toString(), 40);
        this.add(this.textField, "Default base URI");
        this.yearCheckBox = new JCheckBox("Include year", prefs.isIncludeYear());
        this.add(this.yearCheckBox);
        this.monthCheckBox = new JCheckBox("Include month", prefs.isIncludeMonth());
        this.add(this.monthCheckBox);
        this.dayCheckBox = new JCheckBox("Include day", prefs.isIncludeDay());
        this.add(this.dayCheckBox);
        this.yearCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OntologyPreferencesPanel.this.updateState();
            }
        });
        this.monthCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OntologyPreferencesPanel.this.updateState();
            }
        });
        this.updateState();
    }

    private void updateState() {
        if (this.yearCheckBox.isSelected()) {
            this.monthCheckBox.setEnabled(true);
        } else {
            this.monthCheckBox.setSelected(false);
            this.monthCheckBox.setEnabled(false);
        }
        if (this.monthCheckBox.isSelected()) {
            this.dayCheckBox.setEnabled(true);
        } else {
            this.dayCheckBox.setSelected(false);
            this.dayCheckBox.setEnabled(false);
        }
    }

    public void dispose() {
    }

    public static void showDialog(Component parent) {
        try {
            OntologyPreferencesPanel panel = new OntologyPreferencesPanel();
            panel.setup("Ontology URI Preferences", null);
            panel.initialise();
            panel.setPreferredSize(new Dimension(600, 300));
            int ret = JOptionPane.showConfirmDialog(parent, (Object)panel, "Default Ontology URI Base", 2, -1);
            if (ret == 0) {
                panel.applyChanges();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

