/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListSectionHeader;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.library.OntologyCatalogManager;
import org.protege.editor.owl.ui.ontology.imports.OntologyImportItem;
import org.protege.editor.owl.ui.ontology.imports.wizard.ImportInfo;
import org.protege.editor.owl.ui.ontology.imports.wizard.OntologyImportWizard;
import org.protege.editor.owl.ui.renderer.OWLOntologyCellRenderer;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.XmlBaseContext;
import org.protege.xmlcatalog.entry.Entry;
import org.protege.xmlcatalog.entry.UriEntry;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.util.SimpleIRIMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyImportsList
extends MList {
    private static final long serialVersionUID = -1532513638674168922L;
    private static final Logger logger = Logger.getLogger(OntologyImportsList.class);
    private OWLEditorKit eKit;
    private OWLOntology ont;
    private MListSectionHeader directImportsHeader;
    private MListSectionHeader indirectImportsHeader;
    private OntologyImportWizard wizard;
    private OWLOntologyChangeListener ontChangeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            OntologyImportsList.this.handleOntologyChanges(changes);
        }
    };

    public OntologyImportsList(OWLEditorKit eKit) {
        this.eKit = eKit;
        this.setCellRenderer(new OWLOntologyCellRenderer(eKit){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof OntologyImportItem) {
                    value = ((OntologyImportItem)value).getImportDeclaration().getIRI();
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.directImportsHeader = new MListSectionHeader(){

            public String getName() {
                return "Direct Imports";
            }

            public boolean canAdd() {
                return true;
            }
        };
        this.indirectImportsHeader = new MListSectionHeader(){

            public String getName() {
                return "Indirect Imports";
            }

            public boolean canAdd() {
                return false;
            }
        };
        eKit.getOWLModelManager().addOntologyChangeListener(this.ontChangeListener);
    }

    protected void handleAdd() {
        this.wizard = new OntologyImportWizard((Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this.eKit.getWorkspace())), this.eKit);
        int ret = this.wizard.showModalDialog();
        if (ret == 0) {
            OWLOntologyManager manager = this.eKit.getModelManager().getOWLOntologyManager();
            OntologyCatalogManager catalogManager = this.eKit.getOWLModelManager().getOntologyCatalogManager();
            OWLOntology activeOntology = this.eKit.getModelManager().getActiveOntology();
            ArrayList<AddImport> changes = new ArrayList<AddImport>();
            for (ImportInfo importParameters : this.wizard.getImports()) {
                URI physicalLocation;
                IRI importLocation = importParameters.getImportLocation();
                if (this.willRedirectTotheWrongPlace(catalogManager, importLocation, physicalLocation = importParameters.getPhysicalLocation())) {
                    this.addImportMapping(activeOntology, importLocation, IRI.create((URI)physicalLocation));
                }
                OWLImportsDeclaration decl = manager.getOWLDataFactory().getOWLImportsDeclaration(importLocation);
                changes.add(new AddImport(this.ont, decl));
                if (manager.contains(importParameters.getOntologyID())) continue;
                try {
                    manager.makeLoadImportRequest(decl);
                    this.eKit.getModelManager().fireEvent(EventType.ONTOLOGY_LOADED);
                    if (importParameters.getOntologyID() == null || importParameters.getOntologyID().isAnonymous()) continue;
                    OWLOntology importedOnt = manager.getOntology(importParameters.getOntologyID());
                    if (importedOnt == null) {
                        logger.warn((Object)("Imported ontology has unexpected id. During imports processing we anticipated " + importParameters.getOntologyID()));
                        logger.warn((Object)"Please notify the Protege developers via the protege 4 mailing list (p4-feedback@lists.stanford.edu)");
                        continue;
                    }
                    this.eKit.addRecent(manager.getOntologyDocumentIRI(importedOnt).toURI());
                }
                catch (OWLOntologyCreationException ooce) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)"Exception caught importing ontologies", (Throwable)ooce);
                }
            }
            this.eKit.getModelManager().applyChanges(changes);
        }
    }

    private boolean willRedirectTotheWrongPlace(OntologyCatalogManager catalogManager, IRI importLocation, URI physicalLocation) {
        if (catalogManager.getRedirect(importLocation.toURI()) == null) {
            return !importLocation.equals(IRI.create((URI)physicalLocation));
        }
        return !physicalLocation.equals(catalogManager.getRedirect(importLocation.toURI()));
    }

    private void addImportMapping(OWLOntology ontology, IRI importLocation, IRI physicalLocation) {
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        manager.addIRIMapper((OWLOntologyIRIMapper)new SimpleIRIMapper(importLocation, physicalLocation));
        try {
            IRI importersDocumentLocation = manager.getOntologyDocumentIRI(ontology);
            if (importersDocumentLocation.getScheme().equals("file")) {
                File f = new File(importersDocumentLocation.toURI());
                XMLCatalog catalog = this.eKit.getModelManager().addRootFolder(f.getParentFile());
                URI physicalUri = CatalogUtilities.relativize((URI)physicalLocation.toURI(), (XmlBaseContext)catalog);
                catalog.addEntry(0, (Entry)new UriEntry("Imports Wizard Entry", (XmlBaseContext)catalog, importLocation.toURI().toString(), physicalUri, null));
                CatalogUtilities.save((XMLCatalog)catalog, (File)OntologyCatalogManager.getCatalogFile(f.getParentFile()));
            }
        }
        catch (Throwable t) {
            ProtegeApplication.getErrorLog().logError(t);
        }
    }

    public void setOntology(OWLOntology ont) {
        this.ont = ont;
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(this.directImportsHeader);
        for (OWLImportsDeclaration decl : ont.getImportsDeclarations()) {
            data.add(new OntologyImportItem(ont, decl, this.eKit));
        }
        data.add(this.indirectImportsHeader);
        try {
            for (OWLOntology ontRef : this.eKit.getOWLModelManager().getOWLOntologyManager().getImportsClosure(ont)) {
                if (ontRef.equals(ont)) continue;
                for (OWLImportsDeclaration dec : ontRef.getImportsDeclarations()) {
                    if (data.contains(dec)) continue;
                    data.add(new OntologyImportItem(ontRef, dec, this.eKit));
                }
            }
        }
        catch (UnknownOWLOntologyException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        this.setListData(data.toArray());
    }

    private void handleOntologyChanges(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!(oWLOntologyChange instanceof AddImport) && !(oWLOntologyChange instanceof RemoveImport) || !oWLOntologyChange.getOntology().equals(this.ont)) continue;
            this.refresh();
            return;
        }
    }

    private void refresh() {
        this.setOntology(this.ont);
    }

    public void dispose() {
        this.eKit.getOWLModelManager().removeOntologyChangeListener(this.ontChangeListener);
    }
}

