/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports.wizard;

import java.awt.Frame;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.core.ui.wizard.Wizard;
import org.protege.editor.core.ui.wizard.WizardPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.ontology.imports.wizard.ImportInfo;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.AnticipateOntologyIdPage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.ImportConfirmationPage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.ImportTypePage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.LibraryPage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.LoadedOntologyPage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.LocalFilePage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.SelectImportLocationPage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.URLPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyImportWizard
extends Wizard {
    private static final Logger logger = Logger.getLogger(OntologyImportWizard.class);
    private Set<ImportInfo> imports = new HashSet<ImportInfo>();
    private boolean customizeImports = false;

    public OntologyImportWizard(Frame owner, OWLEditorKit owlEditorKit) {
        super(owner);
        this.setTitle("Import ontology wizard");
        this.registerWizardPanel("ImportTypePage", (WizardPanel)new ImportTypePage(owlEditorKit));
        this.registerWizardPanel("LocalFilePage", (WizardPanel)new LocalFilePage(owlEditorKit));
        this.registerWizardPanel("URLPage", (WizardPanel)new URLPage(owlEditorKit));
        this.registerWizardPanel(LoadedOntologyPage.ID, (WizardPanel)new LoadedOntologyPage(owlEditorKit));
        this.registerWizardPanel("LibraryPage", (WizardPanel)new LibraryPage(owlEditorKit));
        this.registerWizardPanel("AnticipateOntologyIdPage", (WizardPanel)new AnticipateOntologyIdPage(owlEditorKit));
        this.registerWizardPanel("SelectImportLocationPage", (WizardPanel)new SelectImportLocationPage(owlEditorKit));
        this.registerWizardPanel("ImportConfirmationPage", (WizardPanel)new ImportConfirmationPage(owlEditorKit));
        this.setCurrentPanel("ImportTypePage");
    }

    public void clearImports() {
        this.imports.clear();
    }

    public void addImport(ImportInfo parameters) {
        this.imports.add(parameters);
    }

    public void removeImport(ImportInfo parameters) {
        this.imports.remove(parameters);
    }

    public Set<ImportInfo> getImports() {
        return Collections.unmodifiableSet(this.imports);
    }

    public boolean isCustomizeImports() {
        return this.customizeImports;
    }

    public void setCustomizeImports(boolean customizeImports) {
        this.customizeImports = customizeImports;
    }
}

