/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports.wizard.page;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.library.folder.XmlBaseAlgorithm;
import org.protege.editor.owl.model.repository.MasterOntologyIDExtractor;
import org.protege.editor.owl.ui.AbstractOWLWizardPanel;
import org.protege.editor.owl.ui.ontology.imports.wizard.ImportInfo;
import org.protege.editor.owl.ui.ontology.imports.wizard.OntologyImportWizard;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class AnticipateOntologyIdPage
extends AbstractOWLWizardPanel {
    public static final String ID = "AnticipateOntologyIdPage";
    private JProgressBar progressBar;
    private Runnable checker = new Runnable(){

        public void run() {
            AnticipateOntologyIdPage.this.checkImport();
        }
    };

    public AnticipateOntologyIdPage(OWLEditorKit owlEditorKit) {
        super(ID, "Import verification", owlEditorKit);
    }

    public Object getNextPanelDescriptor() {
        return this.needsImportPage() ? "SelectImportLocationPage" : "ImportConfirmationPage";
    }

    private boolean needsImportPage() {
        File f;
        Set<URI> bases;
        OntologyImportWizard wizard = (OntologyImportWizard)this.getWizard();
        Set<ImportInfo> imports = wizard.getImports();
        if (imports == null || imports.size() != 1) {
            return false;
        }
        ImportInfo parameters = imports.iterator().next();
        ArrayList<IRI> importOptions = new ArrayList<IRI>();
        OWLOntologyID id = parameters.getOntologyID();
        if (id != null && !id.isAnonymous()) {
            importOptions.add(id.getOntologyIRI());
            if (id.getVersionIRI() != null && !importOptions.contains(id.getVersionIRI())) {
                importOptions.add(id.getVersionIRI());
            }
        }
        if (!parameters.getPhysicalLocation().getScheme().equals("file") && !importOptions.contains(parameters.getPhysicalLocation())) {
            importOptions.add(IRI.create((URI)parameters.getPhysicalLocation()));
        }
        if (parameters.getPhysicalLocation().getScheme().equals("file") && importOptions.isEmpty() && (bases = new XmlBaseAlgorithm().getSuggestions(f = new File(parameters.getPhysicalLocation()))).size() == 1) {
            importOptions.add(IRI.create((URI)bases.iterator().next()));
        }
        if (!wizard.isCustomizeImports() && importOptions.size() > 0) {
            parameters.setImportLocation((IRI)importOptions.get(0));
            return false;
        }
        return true;
    }

    protected void createUI(JComponent parent) {
        JPanel panel = new JPanel(new BorderLayout(7, 7));
        panel.add((Component)new JLabel("Please wait.  Verifying import..."), "North");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setIndeterminate(true);
        panel.add((Component)this.progressBar, "South");
        parent.setLayout(new BorderLayout());
        parent.add((Component)panel, "North");
    }

    protected void checkImport() {
        for (ImportInfo parameters : ((OntologyImportWizard)this.getWizard()).getImports()) {
            if (parameters.getOntologyID() != null) continue;
            try {
                MasterOntologyIDExtractor extractor = new MasterOntologyIDExtractor(parameters.getPhysicalLocation());
                OWLOntologyID id = extractor.getOntologyId();
                if (id != null) {
                    parameters.setOntologyID(id);
                    continue;
                }
                parameters.setOntologyID(null);
            }
            catch (Throwable t) {
                ProtegeApplication.getErrorLog().logError(t);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnticipateOntologyIdPage.this.getWizard().setCurrentPanel(AnticipateOntologyIdPage.this.getNextPanelDescriptor());
            }
        });
    }

    public void displayingPanel() {
        this.getWizard().setNextFinishButtonEnabled(false);
        Thread t = new Thread(this.checker);
        t.start();
    }
}

