/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports.wizard.page;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.MalformedURLException;
import javax.swing.JComponent;
import org.protege.editor.core.ui.OpenFromURLPanel;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.ontology.imports.wizard.ImportInfo;
import org.protege.editor.owl.ui.ontology.imports.wizard.OntologyImportWizard;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.ImportConfirmationPage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.OntologyImportPage;
import org.protege.editor.owl.ui.ontology.imports.wizard.page.SelectImportLocationPage;

public class URLPage
extends OntologyImportPage {
    public static final String ID = "URLPage";
    public OpenFromURLPanel urlPanel;
    private boolean displayed = false;

    public URLPage(OWLEditorKit owlEditorKit) {
        super(ID, "Import from URL", owlEditorKit);
    }

    protected void createUI(JComponent parent) {
        this.setInstructions("Please specify the URL that points to the file that contains the ontology.  (Please note that this should be the physical URL, rather than the ontology URI)");
        parent.setLayout(new BorderLayout());
        this.urlPanel = new OpenFromURLPanel(){

            protected boolean isValidURI() {
                try {
                    if (super.isValidURI()) {
                        this.getURI().toURL();
                        return true;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return false;
            }
        };
        parent.add((Component)this.urlPanel, "Center");
        parent.add((Component)this.createCustomizedImportsComponent(), "South");
    }

    public Object getBackPanelDescriptor() {
        return "ImportTypePage";
    }

    public Object getNextPanelDescriptor() {
        return "AnticipateOntologyIdPage";
    }

    public void displayingPanel() {
        this.urlPanel.requestFocus();
        this.getWizard().setNextFinishButtonEnabled(this.urlPanel.isValid());
        if (!this.displayed) {
            this.urlPanel.addStatusChangedListener(new InputVerificationStatusChangedListener(){

                public void verifiedStatusChanged(boolean newState) {
                    URLPage.this.getWizard().setNextFinishButtonEnabled(newState);
                }
            });
        }
        this.displayed = true;
    }

    public void aboutToHidePanel() {
        OntologyImportWizard wizard = this.getWizard();
        wizard.clearImports();
        ImportInfo parameters = new ImportInfo();
        parameters.setPhysicalLocation(this.urlPanel.getURI());
        wizard.addImport(parameters);
        ((SelectImportLocationPage)this.getWizardModel().getPanel((Object)"SelectImportLocationPage")).setBackPanelDescriptor(ID);
        ((ImportConfirmationPage)this.getWizardModel().getPanel((Object)"ImportConfirmationPage")).setBackPanelDescriptor(ID);
        super.aboutToHidePanel();
    }
}

