/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.location;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.protege.editor.core.FileUtils;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.SaveConfirmationPanel;
import org.protege.editor.owl.ui.renderer.OWLOntologyCellRenderer;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhysicalLocationPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(PhysicalLocationPanel.class);
    private static final Color ROLL_OVER_COLOR = new Color(50, 50, 255);
    private OWLEditorKit owlEditorKit;
    private MList ontologiesPanel;
    private Set<OWLOntology> ontologies;
    private ReloadMListButton reload;
    private ShowFileMListButton showFile;
    private SaveMListButton saveFile;

    public PhysicalLocationPanel(OWLEditorKit owlEditorKit) {
        this(owlEditorKit, owlEditorKit.getOWLModelManager().getOntologies());
    }

    public PhysicalLocationPanel(OWLEditorKit owlEditorKit, Set<OWLOntology> ontologies) {
        this.owlEditorKit = owlEditorKit;
        this.ontologies = ontologies;
        this.createUI();
    }

    public Set<OWLOntology> getSelectedOntologies() {
        HashSet<OWLOntology> onts = new HashSet<OWLOntology>();
        for (Object sel : this.ontologiesPanel.getSelectedValues()) {
            if (!(sel instanceof OntologyListItem)) continue;
            onts.add(((OntologyListItem)sel).ont);
        }
        return onts;
    }

    public void setOntologies(Set<OWLOntology> ontologies) {
        this.ontologies = ontologies;
        this.reload();
    }

    private void createUI() {
        this.setLayout(new BorderLayout(3, 3));
        this.reload = new ReloadMListButton();
        this.showFile = new ShowFileMListButton();
        this.saveFile = new SaveMListButton();
        this.ontologiesPanel = new MList(){

            protected List<MListButton> getButtons(Object value) {
                ArrayList<MListButton> buttons = new ArrayList<MListButton>(super.getButtons(value));
                buttons.add(PhysicalLocationPanel.this.reload);
                OWLOntology ont = ((OntologyListItem)value).ont;
                if (PhysicalLocationPanel.this.owlEditorKit.getModelManager().getOntologyPhysicalURI(ont).getScheme().equals("file")) {
                    buttons.add(PhysicalLocationPanel.this.showFile);
                }
                if (PhysicalLocationPanel.this.owlEditorKit.getModelManager().getDirtyOntologies().contains(ont)) {
                    buttons.add(PhysicalLocationPanel.this.saveFile);
                }
                return buttons;
            }
        };
        this.ontologiesPanel.setCellRenderer((ListCellRenderer)new OntologyListCellRenderer());
        this.load();
        JPanel boxHolder = new JPanel(new BorderLayout());
        boxHolder.setOpaque(false);
        boxHolder.add((Component)this.ontologiesPanel, "North");
        this.add((Component)ComponentFactory.createScrollPane((JComponent)boxHolder), "Center");
    }

    private void load() {
        OWLModelManager mngr = this.owlEditorKit.getModelManager();
        TreeSet<OWLObject> ts = new TreeSet<OWLObject>(mngr.getOWLObjectComparator());
        ts.addAll(this.ontologies);
        ArrayList<OntologyListItem> items = new ArrayList<OntologyListItem>();
        for (OWLOntology oWLOntology : ts) {
            items.add(new OntologyListItem(oWLOntology));
        }
        this.ontologiesPanel.setListData(items.toArray());
    }

    private void reload() {
        this.load();
        this.revalidate();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 500);
    }

    public static void showDialog(OWLEditorKit owlEditorKit) {
        PhysicalLocationPanel panel = new PhysicalLocationPanel(owlEditorKit);
        JOptionPane pane = new JOptionPane(panel, -1, -1);
        JDialog dlg = pane.createDialog((Component)((Object)owlEditorKit.getWorkspace()), "Ontology source locations");
        dlg.setResizable(true);
        dlg.setVisible(true);
    }

    private void handleSave(OWLOntology ont) {
        try {
            this.owlEditorKit.getOWLModelManager().save(ont);
            this.owlEditorKit.addRecent(this.owlEditorKit.getOWLModelManager().getOntologyPhysicalURI(ont));
            SaveConfirmationPanel.showDialog(this.owlEditorKit, Collections.singleton(ont));
            this.reload();
        }
        catch (OWLOntologyStorageException e) {
            ErrorLogPanel.showErrorDialog((Throwable)e);
        }
    }

    private void handleReload(OWLOntology ont) {
        try {
            this.owlEditorKit.getModelManager().reload(ont);
        }
        catch (OWLOntologyCreationException e) {
            JOptionPane.showMessageDialog((Component)((Object)this.owlEditorKit.getWorkspace()), "<html>Failed to reload ontology<p><p>" + this.owlEditorKit.getModelManager().getRendering((OWLObject)ont) + ".</html>");
        }
    }

    private void handleShowFile(OWLOntology ont) {
        URI physicalURI = this.owlEditorKit.getOWLModelManager().getOntologyPhysicalURI(ont);
        if (!physicalURI.getScheme().equals("file")) {
            throw new IllegalArgumentException("URI must be a file URI!");
        }
        try {
            FileUtils.showFile((File)new File(physicalURI));
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
    }

    private void handleClose(OWLOntology ont) {
        if (this.owlEditorKit.getModelManager().removeOntology(ont)) {
            this.ontologies.remove(ont);
            this.reload();
        } else {
            ProtegeManager.getInstance().disposeOfEditorKit((EditorKit)this.owlEditorKit);
        }
    }

    private class SaveMListButton
    extends MListButton {
        protected SaveMListButton() {
            super("Save ontology", ROLL_OVER_COLOR, new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (PhysicalLocationPanel.this.ontologiesPanel.getSelectedValue() instanceof OntologyListItem) {
                        OntologyListItem item = (OntologyListItem)PhysicalLocationPanel.this.ontologiesPanel.getSelectedValue();
                        PhysicalLocationPanel.this.handleSave(item.ont);
                    }
                }
            });
        }

        public void paintButtonContent(Graphics2D g) {
            int w = this.getBounds().width;
            int h = this.getBounds().height;
            int x = this.getBounds().x;
            int y = this.getBounds().y;
            g.drawRect(x + 4, y + 4, w - 8, h - 8);
            g.drawRect(x + 6, y + 4, w - 12, (h - 8) / 2);
            g.drawRect(x + 8, y + (h - 8) / 2 + 1, 2, (h - 8) / 2 - 2);
        }
    }

    private class ShowFileMListButton
    extends MListButton {
        protected ShowFileMListButton() {
            super("Show source file", ROLL_OVER_COLOR, new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (PhysicalLocationPanel.this.ontologiesPanel.getSelectedValue() instanceof OntologyListItem) {
                        OntologyListItem item = (OntologyListItem)PhysicalLocationPanel.this.ontologiesPanel.getSelectedValue();
                        PhysicalLocationPanel.this.handleShowFile(item.ont);
                    }
                }
            });
        }

        public void paintButtonContent(Graphics2D g) {
            int w = this.getBounds().width;
            int h = this.getBounds().height;
            int x = this.getBounds().x;
            int y = this.getBounds().y;
            g.drawOval(x + 3, y + 3, 6, 6);
            g.drawLine(x + 8, y + 8, x + w - 5, y + h - 5);
        }
    }

    private class ReloadMListButton
    extends MListButton {
        protected ReloadMListButton() {
            super("Reload", ROLL_OVER_COLOR, new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (PhysicalLocationPanel.this.ontologiesPanel.getSelectedValue() instanceof OntologyListItem) {
                        OntologyListItem item = (OntologyListItem)PhysicalLocationPanel.this.ontologiesPanel.getSelectedValue();
                        PhysicalLocationPanel.this.handleReload(item.ont);
                    }
                }
            });
        }

        public void paintButtonContent(Graphics2D g) {
            int w = this.getBounds().width;
            int h = this.getBounds().height;
            int x = this.getBounds().x;
            int y = this.getBounds().y;
            g.drawArc(x + 4, y + 4, w - 8, h - 8, 0, -270);
            Polygon arrowHead = new Polygon(new int[]{x + w / 2 + 3, x + w / 2, x + w / 2}, new int[]{y + 4, y + 2, y + 6}, 3);
            g.drawPolygon(arrowHead);
        }
    }

    private class OntologyListCellRenderer
    implements ListCellRenderer {
        OntologySourcePanel panel;

        private OntologyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.panel == null) {
                this.panel = new OntologySourcePanel();
            }
            this.panel.setOntology(((OntologyListItem)value).ont);
            if (isSelected) {
                this.panel.setBackground(jList.getSelectionBackground());
            } else {
                this.panel.setBackground(jList.getBackground());
            }
            return this.panel;
        }
    }

    private class OntologySourcePanel
    extends JPanel {
        private JLabel locURILabel;
        private JLabel ontURILabel;

        public OntologySourcePanel() {
            this.setOpaque(true);
            this.setLayout(new BorderLayout(3, 3));
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.ontURILabel = new JLabel();
            this.ontURILabel.setIcon(OWLIcons.getIcon("ontology.png"));
            this.add((Component)this.ontURILabel, "Center");
            this.locURILabel = new JLabel();
            this.locURILabel.setFont(this.locURILabel.getFont().deriveFont(12.0f));
            this.locURILabel.setForeground(Color.DARK_GRAY);
            this.locURILabel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            this.add((Component)this.locURILabel, "South");
        }

        public void setOntology(OWLOntology ont) {
            OWLModelManager mngr = PhysicalLocationPanel.this.owlEditorKit.getModelManager();
            String label = OWLOntologyCellRenderer.getOntologyLabelText(ont, mngr);
            this.ontURILabel.setText(label);
            URI physicalURI = mngr.getOntologyPhysicalURI(ont);
            if (physicalURI.getScheme().equals("file")) {
                this.locURILabel.setText(new File(physicalURI).toString());
            } else {
                this.locURILabel.setText(physicalURI.toString());
            }
        }
    }

    private class OntologyListItem
    implements MListItem {
        private OWLOntology ont;

        private OntologyListItem(OWLOntology ont) {
            this.ont = ont;
        }

        public boolean isEditable() {
            return false;
        }

        public void handleEdit() {
        }

        public boolean isDeleteable() {
            return true;
        }

        public boolean handleDelete() {
            PhysicalLocationPanel.this.handleClose(this.ont);
            return true;
        }

        public String getTooltip() {
            return this.ont.getAxiomCount() + " axioms";
        }
    }
}

