/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.AbstractOWLWizardPanel;
import org.semanticweb.owlapi.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractSelectOntologiesPage
extends AbstractOWLWizardPanel {
    private JList list;

    public AbstractSelectOntologiesPage(Object ID, OWLEditorKit owlEditorKit, String title) {
        super(ID, title, owlEditorKit);
    }

    protected final void createUI(JComponent parent) {
        parent.setLayout(new BorderLayout());
        this.list = new JList();
        this.list.setVisibleRowCount(8);
        this.list.setCellRenderer(this.getOWLEditorKit().getWorkspace().createOWLCellRenderer());
        ArrayList<OWLOntology> orderedOntologies = new ArrayList<OWLOntology>(this.getOWLModelManager().getOntologies());
        Collections.sort(orderedOntologies, this.getOWLModelManager().getOWLObjectComparator());
        this.list.setListData(orderedOntologies.toArray());
        parent.add((Component)new JScrollPane(this.list), "North");
        this.updateSelectionMode();
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                AbstractSelectOntologiesPage.this.handleSelectionChanged();
            }
        });
    }

    private void handleSelectionChanged() {
        this.getWizard().setNextFinishButtonEnabled(!this.getOntologies().isEmpty());
    }

    private void updateSelectionMode() {
        if (this.isMultiSelect()) {
            this.list.getSelectionModel().setSelectionMode(2);
        } else {
            this.list.getSelectionModel().setSelectionMode(0);
        }
    }

    protected boolean isMultiSelect() {
        return true;
    }

    public void aboutToDisplayPanel() {
        super.aboutToDisplayPanel();
        this.updateSelectionMode();
    }

    public Object getNextPanelDescriptor() {
        return "MergeTypePage";
    }

    public void displayingPanel() {
        super.displayingPanel();
        if (this.list.getSelectedValue() == null) {
            Set<OWLOntology> defOnts = this.getDefaultOntologies();
            for (int i = 0; i < this.list.getModel().getSize(); ++i) {
                if (!defOnts.contains((OWLOntology)this.list.getModel().getElementAt(i))) continue;
                this.list.addSelectionInterval(i, i);
            }
        }
        this.list.requestFocus();
    }

    protected Set<OWLOntology> getDefaultOntologies() {
        return Collections.singleton(this.getOWLModelManager().getActiveOntology());
    }

    public Set<OWLOntology> getOntologies() {
        HashSet<OWLOntology> ontologies = new HashSet<OWLOntology>();
        for (Object o : this.list.getSelectedValues()) {
            ontologies.add((OWLOntology)o);
        }
        return ontologies;
    }
}

