/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard.create;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.wizard.AbstractWizardPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.ontology.OntologyPreferences;
import org.protege.editor.owl.ui.ontology.OntologyPreferencesPanel;
import org.protege.editor.owl.ui.ontology.wizard.create.PhysicalLocationPanel;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyIDPanel
extends AbstractWizardPanel {
    public static final String INSTRUCTIONS = "Please specify the ontology IRI.  \n\nThe ontology IRI is used to identify the ontology in the context of the world wide web. It is recommended that you  set the ontology IRI to be the URL where the latest version of the ontology will be published.  If you use a version IRI, then it is recommended that you set the version IRI to be the URL where this version of the ontology will be published.";
    public static final String ID = "ONTOLOGY_ID_PANEL";
    private JTextField ontologyIRIField;
    private JCheckBox enableVersionCheckBox;
    private JTextField versionIRIField;

    public OntologyIDPanel(OWLEditorKit editorKit) {
        super((Object)ID, "Ontology ID", null);
    }

    private void updateState() {
        this.getWizard().setNextFinishButtonEnabled(this.isValidData());
    }

    private boolean isValidData() {
        try {
            String ontTxt = this.ontologyIRIField.getText();
            String versionTxt = this.versionIRIField.getText();
            if (ontTxt == null) {
                return versionTxt == null;
            }
            URI ontologyURI = new URI(ontTxt);
            if (versionTxt != null) {
                URI versionURI = new URI(versionTxt);
                return ontologyURI.isAbsolute() && versionURI.isAbsolute();
            }
            return ontologyURI.isAbsolute();
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    protected void createUI(JComponent parent) {
        this.setInstructions(INSTRUCTIONS);
        this.ontologyIRIField = new JTextField(OntologyPreferences.getInstance().generateURI().toString());
        this.ontologyIRIField.setSelectionStart(this.ontologyIRIField.getText().lastIndexOf("/") + 1);
        this.ontologyIRIField.setSelectionEnd(this.ontologyIRIField.getText().lastIndexOf(".owl"));
        this.ontologyIRIField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                OntologyIDPanel.this.updateState();
            }

            public void removeUpdate(DocumentEvent e) {
                OntologyIDPanel.this.updateState();
            }
        });
        this.enableVersionCheckBox = new JCheckBox("Enable Version Iri");
        this.enableVersionCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OntologyIDPanel.this.versionIRIField.setEnabled(OntologyIDPanel.this.enableVersionCheckBox.isSelected());
                if (OntologyIDPanel.this.versionIRIField.isEnabled()) {
                    OntologyIDPanel.this.versionIRIField.setText(OntologyIDPanel.this.ontologyIRIField.getText());
                }
            }
        });
        this.versionIRIField = new JTextField(this.ontologyIRIField.getText());
        this.versionIRIField.setEnabled(false);
        this.versionIRIField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                OntologyIDPanel.this.updateState();
            }

            public void removeUpdate(DocumentEvent e) {
                OntologyIDPanel.this.updateState();
            }
        });
        JButton but = new JButton("Default base...");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OntologyPreferencesPanel.showDialog((Component)((Object)OntologyIDPanel.this));
                OntologyIDPanel.this.ontologyIRIField.setText(OntologyPreferences.getInstance().generateURI().toString());
            }
        });
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)but, "East");
        Box holderPanel = new Box(3);
        holderPanel.add(new JLabel("Ontology IRI"));
        holderPanel.add(this.ontologyIRIField);
        holderPanel.add(Box.createVerticalStrut(12));
        holderPanel.add(new JLabel("Version IRI"));
        holderPanel.add(this.versionIRIField);
        holderPanel.add(this.enableVersionCheckBox);
        parent.setLayout(new BorderLayout());
        parent.add((Component)holderPanel, "North");
        parent.add((Component)buttonPanel, "South");
    }

    public OWLOntologyID getOntologyID() {
        try {
            URI ontologyURI = new URI(this.ontologyIRIField.getText());
            IRI ontologyIRI = IRI.create((URI)ontologyURI);
            if (this.enableVersionCheckBox.isSelected()) {
                URI versionURI = new URI(this.versionIRIField.getText());
                IRI versionIRI = IRI.create((URI)versionURI);
                return new OWLOntologyID(ontologyIRI, versionIRI);
            }
            return new OWLOntologyID(ontologyIRI);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public Object getNextPanelDescriptor() {
        return PhysicalLocationPanel.ID;
    }

    public void displayingPanel() {
        this.ontologyIRIField.requestFocus();
        this.updateState();
    }
}

