/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard.move;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.wizard.Wizard;
import org.protege.editor.core.ui.wizard.WizardPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.action.OntologyFormatPage;
import org.protege.editor.owl.ui.ontology.wizard.create.PhysicalLocationPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.CreateNewOntologyPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsKit;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsKitConfigurationPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsKitPlugin;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsKitPluginLoader;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsModel;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsWizardKitConfigurationPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.SelectActionPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.SelectKitPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.SelectSourceOntologiesPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.SelectTargetOntologyPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.SelectTargetOntologyTypePanel;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveAxiomsWizard
extends Wizard
implements MoveAxiomsModel {
    private OWLEditorKit editorKit;
    private MoveAxiomsKit selectedKit;
    private Set<OWLOntology> sourceOntologies;
    private OWLOntologyID targetOntologyID;
    private List<MoveAxiomsKit> moveAxiomsKits;
    private Map<String, Object> kitId2FirstPanelId;
    private Map<String, Object> kitId2LastPanelId;
    private List<MoveAxiomsKitConfigurationPanel> panels;
    private URI physicalURI;
    private boolean deleteFromOriginalOntology;
    private boolean addToTargetOntology;
    private OntologyFormatPage ontologyFormatPage;
    private PhysicalLocationPanel ontologyPhysicalLocationPage;

    public MoveAxiomsWizard(OWLEditorKit eKit) {
        this.setTitle("Copy/move/delete axioms");
        this.editorKit = eKit;
        this.sourceOntologies = new HashSet<OWLOntology>();
        this.panels = new ArrayList<MoveAxiomsKitConfigurationPanel>();
        this.selectedKit = null;
        this.kitId2FirstPanelId = new HashMap<String, Object>();
        this.kitId2LastPanelId = new HashMap<String, Object>();
        this.setupKits();
        this.registerWizardPanel("SelectSourceOntologiesPanel", (WizardPanel)new SelectSourceOntologiesPanel(this.editorKit));
        this.registerWizardPanel("AxiomSelectionStrategyPanel", (WizardPanel)new SelectKitPanel(this.editorKit));
        this.registerWizardPanel("SelectActionPanel", (WizardPanel)new SelectActionPanel(this.editorKit));
        this.registerWizardPanel("SelectTargetOntologyTypePanel", (WizardPanel)new SelectTargetOntologyTypePanel(this.editorKit));
        this.registerWizardPanel("SelectTargetOntologyPanel", (WizardPanel)new SelectTargetOntologyPanel(this.editorKit));
        this.registerWizardPanel("ONTOLOGY_ID_PANEL", (WizardPanel)new CreateNewOntologyPanel(this.editorKit));
        this.ontologyPhysicalLocationPage = new PhysicalLocationPanel((EditorKit)this.editorKit);
        this.registerWizardPanel(PhysicalLocationPanel.ID, (WizardPanel)this.ontologyPhysicalLocationPage);
        this.ontologyFormatPage = new OntologyFormatPage((EditorKit)this.editorKit);
        this.registerWizardPanel("ONTOLOGY_FORMAT_PANEL", (WizardPanel)this.ontologyFormatPage);
        for (MoveAxiomsKit kit : this.moveAxiomsKits) {
            List<MoveAxiomsKitConfigurationPanel> panels = kit.getConfigurationPanels();
            for (int i = 0; i < panels.size(); ++i) {
                MoveAxiomsKitConfigurationPanel panel = panels.get(i);
                this.panels.add(panel);
                panel.setup(this.editorKit, this);
                panel.initialise();
                String prevId = "AxiomSelectionStrategyPanel";
                String nextId = "SelectActionPanel";
                if (i == 0) {
                    this.kitId2FirstPanelId.put(kit.getID(), panel.getID());
                    prevId = "AxiomSelectionStrategyPanel";
                }
                if (i > 0) {
                    prevId = panels.get(i - 1).getID();
                }
                if (i < panels.size() - 1) {
                    nextId = panels.get(i + 1).getID();
                }
                if (i == panels.size() - 1) {
                    this.kitId2LastPanelId.put(kit.getID(), panel.getID());
                    nextId = "SelectActionPanel";
                }
                MoveAxiomsWizardKitConfigurationPanel configPanel = new MoveAxiomsWizardKitConfigurationPanel(prevId, nextId, panel, this.editorKit);
                this.registerWizardPanel(panel.getID(), (WizardPanel)configPanel);
            }
        }
        this.setCurrentPanel("SelectSourceOntologiesPanel");
    }

    public Object getFirstPanelIDForKit() {
        return this.kitId2FirstPanelId.get(this.selectedKit.getID());
    }

    public Object getLastPanelIDForKit() {
        return this.kitId2LastPanelId.get(this.selectedKit.getID());
    }

    public List<MoveAxiomsKit> getMoveAxiomsKits() {
        return this.moveAxiomsKits;
    }

    private void setupKits() {
        this.moveAxiomsKits = new ArrayList<MoveAxiomsKit>();
        MoveAxiomsKitPluginLoader loader = new MoveAxiomsKitPluginLoader(this.editorKit);
        for (MoveAxiomsKitPlugin plugin : loader.getPlugins()) {
            try {
                MoveAxiomsKit moveAxiomsKit = (MoveAxiomsKit)plugin.newInstance();
                this.moveAxiomsKits.add(moveAxiomsKit);
            }
            catch (Exception e) {
                ProtegeApplication.getErrorLog().logError((Throwable)e);
            }
        }
        for (MoveAxiomsKit kit : this.moveAxiomsKits) {
            try {
                kit.initialise();
            }
            catch (Exception e) {
                ProtegeApplication.getErrorLog().logError((Throwable)e);
            }
        }
        if (!this.moveAxiomsKits.isEmpty()) {
            Collections.sort(this.moveAxiomsKits, new Comparator<MoveAxiomsKit>(){

                @Override
                public int compare(MoveAxiomsKit kit1, MoveAxiomsKit kit2) {
                    return kit1.getName().compareTo(kit2.getName());
                }
            });
            this.selectedKit = this.moveAxiomsKits.get(0);
        }
    }

    public MoveAxiomsKit getSelectedKit() {
        return this.selectedKit;
    }

    public void setSelectedKit(MoveAxiomsKit selectedKit) {
        this.selectedKit = selectedKit;
    }

    public void dispose() {
        for (MoveAxiomsKitConfigurationPanel panel : this.panels) {
            panel.dispose();
        }
        super.dispose();
    }

    public List<OWLOntologyChange> getChanges() throws OWLOntologyCreationException {
        OWLOntology targetOntology = null;
        if (this.addToTargetOntology) {
            OWLOntologyManager man = this.editorKit.getModelManager().getOWLOntologyManager();
            if (man.contains(this.getTargetOntologyID())) {
                targetOntology = man.getOntology(this.getTargetOntologyID());
            } else {
                targetOntology = this.editorKit.getModelManager().createNewOntology(this.getTargetOntologyID(), this.ontologyPhysicalLocationPage.getLocationURL());
                this.editorKit.getModelManager().getOWLOntologyManager().setOntologyFormat(targetOntology, this.ontologyFormatPage.getFormat());
            }
        }
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        Set<OWLAxiom> axiomsToBeMoved = this.getAxiomsToBeMoved();
        for (OWLAxiom ax : axiomsToBeMoved) {
            for (OWLOntology ont : this.getSourceOntologies()) {
                if (!ont.containsAxiom(ax)) continue;
                if (this.deleteFromOriginalOntology) {
                    changes.add((OWLOntologyChange)new RemoveAxiom(ont, ax));
                }
                if (targetOntology == null) continue;
                changes.add((OWLOntologyChange)new AddAxiom(targetOntology, ax));
            }
        }
        return changes;
    }

    @Override
    public Set<OWLAxiom> getAxiomsToBeMoved() {
        return this.selectedKit.getAxioms(this.sourceOntologies);
    }

    @Override
    public Set<OWLOntology> getSourceOntologies() {
        return this.sourceOntologies;
    }

    @Override
    public void setSourceOntologies(Set<OWLOntology> sourceOntologies) {
        this.sourceOntologies = sourceOntologies;
    }

    @Override
    public OWLOntologyID getTargetOntologyID() {
        return this.targetOntologyID;
    }

    @Override
    public void setTargetOntologyID(OWLOntologyID targetOntologyID) {
        this.targetOntologyID = targetOntologyID;
    }

    public void setDeleteFromOriginalOntology(boolean deleteFromOriginalOntology) {
        this.deleteFromOriginalOntology = deleteFromOriginalOntology;
    }

    public void setAddToTargetOntology(boolean addToTargetOntology) {
        this.addToTargetOntology = addToTargetOntology;
    }
}

