/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard.move;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.protege.editor.core.ui.wizard.WizardPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.ontology.wizard.move.AbstractMoveAxiomsWizardPanel;

public class SelectActionPanel
extends AbstractMoveAxiomsWizardPanel {
    public static final String ID = "SelectActionPanel";
    private JRadioButton moveAxiomsButton;
    private JRadioButton copyAxiomsButton;
    private JRadioButton deleteAxiomsButton;

    public SelectActionPanel(OWLEditorKit owlEditorKit) {
        super(ID, "Copy, move or delete axioms", owlEditorKit);
    }

    protected void createUI(JComponent parent) {
        parent.setLayout(new BorderLayout());
        this.copyAxiomsButton = new JRadioButton("Copy axioms (to another ontology)", true);
        this.moveAxiomsButton = new JRadioButton("Move axioms (to another ontology)");
        this.deleteAxiomsButton = new JRadioButton("Delete axioms");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectActionPanel.this.getWizard().resetButtonStates();
            }
        };
        this.copyAxiomsButton.addActionListener(actionListener);
        this.moveAxiomsButton.addActionListener(actionListener);
        this.deleteAxiomsButton.addActionListener(actionListener);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.copyAxiomsButton);
        bg.add(this.moveAxiomsButton);
        bg.add(this.deleteAxiomsButton);
        Box box = new Box(1);
        box.add(this.copyAxiomsButton);
        box.add(this.moveAxiomsButton);
        box.add(this.deleteAxiomsButton);
        parent.add(box);
        this.setInstructions("Specify whether you want to copy, move or delete the axioms from the source ontology.");
    }

    public Object getBackPanelDescriptor() {
        return this.getWizard().getLastPanelIDForKit();
    }

    public Object getNextPanelDescriptor() {
        if (this.isAddToTargetOntology()) {
            return "SelectTargetOntologyTypePanel";
        }
        return WizardPanel.FINISH;
    }

    public void aboutToDisplayPanel() {
        super.aboutToDisplayPanel();
    }

    private boolean isDeleteFromOriginalOntology() {
        return this.deleteAxiomsButton.isSelected() || this.moveAxiomsButton.isSelected();
    }

    private boolean isAddToTargetOntology() {
        return this.moveAxiomsButton.isSelected() || this.copyAxiomsButton.isSelected();
    }

    public void aboutToHidePanel() {
        super.aboutToHidePanel();
        this.getWizard().setDeleteFromOriginalOntology(this.isDeleteFromOriginalOntology());
        this.getWizard().setAddToTargetOntology(this.isAddToTargetOntology());
    }
}

