/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard.move;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.protege.editor.core.ui.util.CheckTable;
import org.protege.editor.owl.ui.ontology.wizard.move.FilteredAxiomsModel;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsKitConfigurationPanel;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectAxiomsPanel
extends MoveAxiomsKitConfigurationPanel {
    private CheckTable<OWLAxiom> list;
    private Set<OWLAxiom> unfilteredAxioms;
    private FilteredAxiomsModel filterModel;
    private String id;

    public SelectAxiomsPanel(FilteredAxiomsModel filterModel, String id) {
        this.filterModel = filterModel;
        this.id = id;
    }

    @Override
    public void initialise() {
        this.setLayout(new BorderLayout());
        this.list = new CheckTable("Axioms");
        OWLCellRenderer owlCellRenderer = new OWLCellRenderer(this.getEditorKit());
        owlCellRenderer.setHighlightKeywords(true);
        this.list.setDefaultRenderer((TableCellRenderer)owlCellRenderer);
        JScrollPane scroller = new JScrollPane((Component)this.list);
        this.add(scroller);
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return "Confirm axioms to extract";
    }

    @Override
    public String getInstructions() {
        return "Confirm the axioms that are to be used in the extraction.";
    }

    @Override
    public void update() {
        Set<OWLAxiom> axiomsFromKit = this.filterModel.getUnfilteredAxioms(this.getModel().getSourceOntologies());
        if (this.unfilteredAxioms == null || !((Object)this.unfilteredAxioms).equals(axiomsFromKit)) {
            this.unfilteredAxioms = axiomsFromKit;
            this.list.getModel().setData(new ArrayList<OWLAxiom>(this.unfilteredAxioms), true);
            this.list.checkAll(true);
        }
    }

    @Override
    public void commit() {
        this.filterModel.setFilteredAxioms(this.getFilteredAxioms());
    }

    private Set<OWLAxiom> getFilteredAxioms() {
        return new HashSet<OWLAxiom>(this.list.getFilteredValues());
    }
}

