/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard.move.byprofile;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsKitConfigurationPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.byprofile.MoveAxiomsByProfileKit;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWL2ELProfile;
import org.semanticweb.owlapi.profiles.OWL2Profile;
import org.semanticweb.owlapi.profiles.OWLProfile;

public class ProfileSelectorPanel
extends MoveAxiomsKitConfigurationPanel {
    private MoveAxiomsByProfileKit kit;
    private JRadioButton owlDLButton;
    private JRadioButton elPPButton;
    private JRadioButton owl2Button;

    public ProfileSelectorPanel(MoveAxiomsByProfileKit kit) {
        this.kit = kit;
    }

    public void initialise() {
        this.setLayout(new BoxLayout(this, 3));
        this.owlDLButton = new JRadioButton("OWL DL", true);
        this.add(this.owlDLButton);
        this.owl2Button = new JRadioButton("OWL 2");
        this.add(this.owl2Button);
        this.elPPButton = new JRadioButton("EL++");
        this.add(this.elPPButton);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.owl2Button);
        bg.add(this.owlDLButton);
        bg.add(this.elPPButton);
    }

    public void dispose() {
    }

    public String getID() {
        return this.getClass().getName();
    }

    public String getTitle() {
        return "Select profile";
    }

    public String getInstructions() {
        return "Select the OWL profile that you wish to extract.";
    }

    public void update() {
    }

    public void commit() {
        this.kit.setProfile(this.getSelectedProfile());
    }

    private OWLProfile getSelectedProfile() {
        if (this.owl2Button.isSelected()) {
            return new OWL2Profile();
        }
        if (this.owlDLButton.isSelected()) {
            return new OWL2DLProfile();
        }
        if (this.elPPButton.isSelected()) {
            return new OWL2ELProfile();
        }
        return null;
    }
}

