/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard.move.bytype;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.list.MListSectionHeader;
import org.protege.editor.core.ui.list.RemovableObjectList;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsKitConfigurationPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.bytype.MoveAxiomsByTypeKit;
import org.semanticweb.owlapi.model.AxiomType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxiomTypeSelectorPanel
extends MoveAxiomsKitConfigurationPanel {
    private MoveAxiomsByTypeKit kit;
    private MList typeSource;
    private RemovableObjectList<AxiomType> typeSelection;

    public AxiomTypeSelectorPanel(MoveAxiomsByTypeKit kit) {
        this.kit = kit;
    }

    @Override
    public void initialise() {
        this.setLayout(new BoxLayout(this, 2));
        this.typeSource = new MList();
        List data = this.createTypesByTypeList();
        this.typeSource.setListData(data.toArray());
        this.typeSelection = new RemovableObjectList();
        this.typeSelection.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object o, int i, boolean b, boolean b1) {
                if (o instanceof RemovableObjectList.RemovableObjectListItem) {
                    o = ((RemovableObjectList.RemovableObjectListItem)o).getObject();
                }
                return super.getListCellRendererComponent((JList<?>)jList, o, i, b, b1);
            }
        });
        JButton button = new JButton(new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                AxiomTypeSelectorPanel.this.addSelectedItems();
            }
        });
        Box buttonPanel = new Box(3);
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(button);
        buttonPanel.add(Box.createVerticalGlue());
        this.add(Box.createHorizontalGlue());
        this.add(new JScrollPane((Component)this.typeSource));
        this.add(buttonPanel);
        this.add(new JScrollPane((Component)this.typeSelection));
        this.add(Box.createHorizontalGlue());
    }

    private void addSelectedItems() {
        HashSet<AxiomType> selectedTypes = new HashSet<AxiomType>();
        for (Object o : this.typeSource.getSelectedValues()) {
            if (!(o instanceof TypeItem)) continue;
            AxiomType axiomType = ((TypeItem)o).getType();
            selectedTypes.add(axiomType);
        }
        selectedTypes.removeAll(this.typeSelection.getListItems());
        this.typeSelection.addObject(selectedTypes);
    }

    private Set<AxiomType> getSelection() {
        return new HashSet<AxiomType>(this.typeSelection.getListItems());
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public String getTitle() {
        return "Axioms by type";
    }

    @Override
    public String getInstructions() {
        return "Please select the types of axiom you would like to move/copy.";
    }

    @Override
    public void update() {
    }

    @Override
    public void commit() {
        this.kit.setTypes(this.getSelection());
    }

    private List createTypesByTypeList() {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(new MListSectionHeader(){

            public String getName() {
                return "Class Axioms";
            }

            public boolean canAdd() {
                return false;
            }
        });
        data.add(new TypeItem(AxiomType.EQUIVALENT_CLASSES));
        data.add(new TypeItem(AxiomType.SUBCLASS_OF));
        data.add(new TypeItem(AxiomType.DISJOINT_CLASSES));
        data.add(new MListSectionHeader(){

            public String getName() {
                return "Object Property Axioms";
            }

            public boolean canAdd() {
                return false;
            }
        });
        data.add(new TypeItem(AxiomType.SUB_OBJECT_PROPERTY));
        data.add(new TypeItem(AxiomType.EQUIVALENT_OBJECT_PROPERTIES));
        data.add(new TypeItem(AxiomType.DISJOINT_OBJECT_PROPERTIES));
        data.add(new TypeItem(AxiomType.INVERSE_OBJECT_PROPERTIES));
        data.add(new TypeItem(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY));
        data.add(new TypeItem(AxiomType.OBJECT_PROPERTY_DOMAIN));
        data.add(new TypeItem(AxiomType.OBJECT_PROPERTY_RANGE));
        data.add(new TypeItem(AxiomType.FUNCTIONAL_OBJECT_PROPERTY));
        data.add(new TypeItem(AxiomType.TRANSITIVE_OBJECT_PROPERTY));
        data.add(new TypeItem(AxiomType.SYMMETRIC_OBJECT_PROPERTY));
        data.add(new TypeItem(AxiomType.ASYMMETRIC_OBJECT_PROPERTY));
        data.add(new TypeItem(AxiomType.REFLEXIVE_OBJECT_PROPERTY));
        data.add(new TypeItem(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY));
        data.add(new TypeItem(AxiomType.SUB_PROPERTY_CHAIN_OF));
        data.add(new MListSectionHeader(){

            public String getName() {
                return "Data Property Axioms";
            }

            public boolean canAdd() {
                return false;
            }
        });
        data.add(new TypeItem(AxiomType.SUB_DATA_PROPERTY));
        data.add(new TypeItem(AxiomType.EQUIVALENT_DATA_PROPERTIES));
        data.add(new TypeItem(AxiomType.DISJOINT_DATA_PROPERTIES));
        data.add(new TypeItem(AxiomType.DATA_PROPERTY_DOMAIN));
        data.add(new TypeItem(AxiomType.DATA_PROPERTY_RANGE));
        data.add(new TypeItem(AxiomType.FUNCTIONAL_DATA_PROPERTY));
        data.add(new MListSectionHeader(){

            public String getName() {
                return "Individual Axioms";
            }

            public boolean canAdd() {
                return false;
            }
        });
        data.add(new TypeItem(AxiomType.CLASS_ASSERTION));
        data.add(new TypeItem(AxiomType.DIFFERENT_INDIVIDUALS));
        data.add(new TypeItem(AxiomType.SAME_INDIVIDUAL));
        data.add(new TypeItem(AxiomType.OBJECT_PROPERTY_ASSERTION));
        data.add(new TypeItem(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION));
        data.add(new TypeItem(AxiomType.DATA_PROPERTY_ASSERTION));
        data.add(new TypeItem(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION));
        data.add(new MListSectionHeader(){

            public String getName() {
                return "Annotation Axioms";
            }

            public boolean canAdd() {
                return false;
            }
        });
        data.add(new TypeItem(AxiomType.ANNOTATION_ASSERTION));
        data.add(new MListSectionHeader(){

            public String getName() {
                return "Other Axioms";
            }

            public boolean canAdd() {
                return false;
            }
        });
        data.add(new TypeItem(AxiomType.SWRL_RULE));
        data.add(new TypeItem(AxiomType.DECLARATION));
        data.add(new TypeItem(AxiomType.DISJOINT_UNION));
        return data;
    }

    class TypeItem
    implements MListItem {
        private AxiomType type;

        TypeItem(AxiomType type) {
            this.type = type;
        }

        public AxiomType getType() {
            return this.type;
        }

        public String toString() {
            return this.type.toString();
        }

        public boolean isEditable() {
            return false;
        }

        public void handleEdit() {
        }

        public boolean isDeleteable() {
            return false;
        }

        public boolean handleDelete() {
            return false;
        }

        public String getTooltip() {
            return null;
        }
    }
}

