/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.preferences;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.owl.model.find.OWLEntityFinderPreferences;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditorPreferences;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;

public class GeneralPreferencesPanel
extends OWLPreferencesPanel {
    public static final String DIALOGS_ALWAYS_CENTRED = "DIALOGS_ALWAYS_CENTRED";
    private JRadioButton simpleSearchButton;
    private JRadioButton regularExpressionSearchButton;
    private JSpinner findDelaySpinner;
    private JSpinner checkDelaySpinner;
    private static final String SECOND_TOOL_TIP = "1000 = 1 second";
    private JCheckBox alwaysCentreDialogsCheckbox;
    private JCheckBox detachedWindowsFloat;

    public void applyChanges() {
        ExpressionEditorPreferences.getInstance().setCheckDelay((Integer)this.checkDelaySpinner.getModel().getValue());
        OWLEntityFinderPreferences prefs = OWLEntityFinderPreferences.getInstance();
        prefs.setSearchDelay(((Double)this.findDelaySpinner.getModel().getValue()).intValue());
        prefs.setUseRegularExpressions(this.regularExpressionSearchButton.isSelected());
        Preferences appPrefs = PreferencesManager.getInstance().getApplicationPreferences("org.protege.editor.core.application");
        appPrefs.putBoolean(DIALOGS_ALWAYS_CENTRED, this.alwaysCentreDialogsCheckbox.isSelected());
        appPrefs.putBoolean("DETACHED_WINDOWS_FLOAT", this.detachedWindowsFloat.isSelected());
    }

    public void initialise() throws Exception {
        this.setLayout(new BorderLayout());
        JPanel editorDelayPanel = new JPanel(new FlowLayout(3));
        int checkDelay = ExpressionEditorPreferences.getInstance().getCheckDelay();
        this.checkDelaySpinner = new JSpinner(new SpinnerNumberModel(checkDelay, 0, 10000, 50));
        this.checkDelaySpinner.setToolTipText(SECOND_TOOL_TIP);
        editorDelayPanel.add(new JLabel("Editor delay (ms)"));
        editorDelayPanel.add(this.checkDelaySpinner);
        Box editorPanel = new Box(3);
        editorPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Editor"), BorderFactory.createEmptyBorder(7, 7, 7, 7)));
        editorPanel.add(editorDelayPanel);
        OWLEntityFinderPreferences prefs = OWLEntityFinderPreferences.getInstance();
        this.findDelaySpinner = new JSpinner(new SpinnerNumberModel(prefs.getSearchDelay(), 0.0, 10000.0, 50.0));
        this.findDelaySpinner.setToolTipText(SECOND_TOOL_TIP);
        JPanel findDelayPanel = new JPanel(new FlowLayout(3));
        findDelayPanel.add(new JLabel("Search delay (ms)"));
        findDelayPanel.add(this.findDelaySpinner);
        this.simpleSearchButton = new JRadioButton("Simple search (using simple wildcards *)", !prefs.isUseRegularExpressions());
        this.regularExpressionSearchButton = new JRadioButton("Full regular expression search", prefs.isUseRegularExpressions());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.simpleSearchButton);
        bg.add(this.regularExpressionSearchButton);
        findDelayPanel.setAlignmentX(0.0f);
        this.simpleSearchButton.setAlignmentX(0.0f);
        this.regularExpressionSearchButton.setAlignmentX(0.0f);
        Box searchPanel = new Box(3);
        searchPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Search"), BorderFactory.createEmptyBorder(7, 7, 7, 7)));
        searchPanel.add(findDelayPanel);
        searchPanel.add(this.simpleSearchButton);
        searchPanel.add(this.regularExpressionSearchButton);
        Preferences appPrefs = PreferencesManager.getInstance().getApplicationPreferences("org.protege.editor.core.application");
        this.alwaysCentreDialogsCheckbox = new JCheckBox("Centre dialogs on workspace");
        this.alwaysCentreDialogsCheckbox.setSelected(appPrefs.getBoolean(DIALOGS_ALWAYS_CENTRED, false));
        this.detachedWindowsFloat = new JCheckBox("Detached windows float");
        this.detachedWindowsFloat.setSelected(appPrefs.getBoolean("DETACHED_WINDOWS_FLOAT", true));
        editorPanel.setAlignmentX(0.0f);
        searchPanel.setAlignmentX(0.0f);
        this.alwaysCentreDialogsCheckbox.setAlignmentX(0.0f);
        this.detachedWindowsFloat.setAlignmentX(0.0f);
        Box holder = new Box(3);
        holder.add(editorPanel);
        holder.add(Box.createVerticalStrut(7));
        holder.add(searchPanel);
        holder.add(Box.createVerticalStrut(7));
        holder.add(this.alwaysCentreDialogsCheckbox);
        holder.add(this.detachedWindowsFloat);
        this.add(holder, "North");
    }

    public void dispose() {
    }
}

