/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.entity.AutoIDGenerator;
import org.protege.editor.owl.model.entity.CustomLabelDescriptor;
import org.protege.editor.owl.model.entity.EntityCreationPreferences;
import org.protege.editor.owl.model.entity.IterativeAutoIDGenerator;
import org.protege.editor.owl.model.entity.LabelDescriptor;
import org.protege.editor.owl.model.entity.MatchRendererLabelDescriptor;
import org.protege.editor.owl.model.entity.PseudoRandomAutoIDGenerator;
import org.protege.editor.owl.model.entity.UniqueIdGenerator;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class NewEntitiesPreferencesPanel
extends OWLPreferencesPanel
implements ActionListener {
    private static final long serialVersionUID = -319986509127880607L;
    private static final String SEP_COLON = ":";
    private static final String SEP_HASH = "#";
    private static final String SEP_SLASH = "/";
    private Logger logger = Logger.getLogger(NewEntitiesPreferencesPanel.class);
    private JRadioButton autoIDURIFragment;
    private JRadioButton colonButton;
    private JRadioButton hashButton;
    private JRadioButton nameAsURIFragment;
    private JRadioButton slashButton;
    private JRadioButton uriBaseActiveOntology;
    private JRadioButton uriBaseSpecifiedURI;
    private JTextField uriDefaultBaseField;
    private IRI labelAnnotation = null;
    private JButton annotationSelectButton;
    private JCheckBox autoIDLabel;
    private JCheckBox nameAsLabel;
    private JComboBox annotationLangSelector;
    private JLabel langLabel;
    private JLabel uriLabel;
    private JRadioButton customLabelButton;
    private JRadioButton sameAsRendererLabelButton;
    private JTextField annotationURILabel;
    private JCheckBox saveIterativeIds;
    private JLabel digitCountLabel;
    private JLabel endLabel;
    private JLabel prefixLabel;
    private JLabel startLabel;
    private JLabel suffixLabel;
    private JPanel autoGeneratedIDPanel;
    private JRadioButton iterativeButton;
    private JRadioButton pseudoRandomButton;
    private JRadioButton uniqueIdButton;
    private JSpinner autoIDEnd;
    private JSpinner autoIDStart;
    private JSpinner autoIDDigitCount;
    private JTextField autoIDPrefix;
    private JTextField autoIDSuffix;

    public void initialise() throws Exception {
        this.setLayout(new GridLayout(3, 1, 0, 12));
        this.add(this.createEntityURIPanel());
        this.add(this.createEntityLabelPanel());
        this.add(this.createAutoGeneratedIDPanel());
    }

    private JPanel createEntityURIPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Entity URI"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.insets = new Insets(12, 12, 0, 12);
        c.anchor = 23;
        panel.add((Component)new JLabel("Start with:"), c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.insets = new Insets(12, 0, 0, 0);
        this.uriBaseActiveOntology = new JRadioButton("Active ontology URI");
        this.uriBaseActiveOntology.setSelected(!EntityCreationPreferences.useDefaultBaseIRI());
        panel.add((Component)this.uriBaseActiveOntology, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 5);
        this.uriBaseSpecifiedURI = new JRadioButton("Specified URI:");
        this.uriBaseSpecifiedURI.setSelected(EntityCreationPreferences.useDefaultBaseIRI());
        panel.add((Component)this.uriBaseSpecifiedURI, c);
        c.gridx = 2;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 12);
        this.uriDefaultBaseField = new JTextField();
        this.uriDefaultBaseField.setText(EntityCreationPreferences.getDefaultBaseIRI().toString());
        panel.add((Component)this.uriDefaultBaseField, c);
        ButtonGroup group = new ButtonGroup();
        group.add(this.uriBaseActiveOntology);
        group.add(this.uriBaseSpecifiedURI);
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 0;
        c.insets = new Insets(11, 12, 0, 12);
        c.weightx = 0.0;
        panel.add((Component)new JLabel("Followed by:"), c);
        c.gridx = 1;
        c.insets = new Insets(11, 0, 0, 0);
        this.hashButton = new JRadioButton(SEP_HASH);
        this.hashButton.setSelected(EntityCreationPreferences.getDefaultSeparator().equals(SEP_HASH));
        panel.add((Component)this.hashButton, c);
        c.gridy = 3;
        c.insets = new Insets(0, 0, 0, 0);
        this.slashButton = new JRadioButton(SEP_SLASH);
        this.slashButton.setSelected(EntityCreationPreferences.getDefaultSeparator().equals(SEP_SLASH));
        panel.add((Component)this.slashButton, c);
        c.gridy = 4;
        c.insets = new Insets(0, 0, 0, 0);
        this.colonButton = new JRadioButton(SEP_COLON);
        this.colonButton.setSelected(EntityCreationPreferences.getDefaultSeparator().equals(SEP_COLON));
        panel.add((Component)this.colonButton, c);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.hashButton);
        group2.add(this.slashButton);
        group2.add(this.colonButton);
        c.gridx = 0;
        c.gridy = 5;
        c.insets = new Insets(11, 12, 0, 12);
        panel.add((Component)new JLabel("End with:"), c);
        c.gridx = 1;
        c.insets = new Insets(11, 0, 0, 0);
        c.gridwidth = 2;
        this.nameAsURIFragment = new JRadioButton("User supplied name");
        this.nameAsURIFragment.setSelected(!EntityCreationPreferences.isFragmentAutoGenerated());
        this.nameAsURIFragment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewEntitiesPreferencesPanel.this.handleActionEndWithName();
            }
        });
        panel.add((Component)this.nameAsURIFragment, c);
        c.gridy = 6;
        c.insets = new Insets(0, 0, 12, 0);
        c.weighty = 1.0;
        this.autoIDURIFragment = new JRadioButton("Auto-generated ID");
        this.autoIDURIFragment.setSelected(EntityCreationPreferences.isFragmentAutoGenerated());
        this.autoIDURIFragment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewEntitiesPreferencesPanel.this.handleActionEndWithID();
            }
        });
        panel.add((Component)this.autoIDURIFragment, c);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.nameAsURIFragment);
        group3.add(this.autoIDURIFragment);
        return panel;
    }

    private JPanel createEntityLabelPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Entity Label"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.fill = 0;
        c.insets = new Insets(12, 12, 0, 0);
        c.anchor = 23;
        this.nameAsLabel = new JCheckBox("Create label from user supplied name");
        this.nameAsLabel.setSelected(EntityCreationPreferences.isGenerateNameLabel());
        this.nameAsLabel.setEnabled(!this.autoIDURIFragment.isSelected());
        panel.add((Component)this.nameAsLabel, c);
        c.gridy = 1;
        c.insets = new Insets(0, 12, 11, 0);
        this.autoIDLabel = new JCheckBox("Create label from auto-generated ID");
        this.autoIDLabel.setSelected(EntityCreationPreferences.isGenerateIDLabel());
        this.autoIDLabel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewEntitiesPreferencesPanel.this.handleActionCreateLabelFromID();
            }
        });
        panel.add((Component)this.autoIDLabel, c);
        Class<? extends LabelDescriptor> labelDescrCls = EntityCreationPreferences.getLabelDescriptorClass();
        c.gridy = 2;
        c.insets = new Insets(0, 12, 0, 0);
        this.sameAsRendererLabelButton = new JRadioButton("Same as label renderer");
        this.sameAsRendererLabelButton.setSelected(labelDescrCls.equals(MatchRendererLabelDescriptor.class));
        panel.add((Component)this.sameAsRendererLabelButton, c);
        c.gridy = 3;
        this.customLabelButton = new JRadioButton("Custom label");
        this.customLabelButton.setSelected(labelDescrCls.equals(CustomLabelDescriptor.class));
        panel.add((Component)this.customLabelButton, c);
        ButtonGroup group = new ButtonGroup();
        group.add(this.sameAsRendererLabelButton);
        group.add(this.customLabelButton);
        c.gridy = 4;
        c.gridwidth = 1;
        c.insets = new Insets(5, 30, 0, 5);
        this.uriLabel = new JLabel("URI");
        panel.add((Component)this.uriLabel, c);
        c.gridx = 1;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.weightx = 1.0;
        this.annotationURILabel = new JTextField();
        this.labelAnnotation = EntityCreationPreferences.getNameLabelIRI();
        if (this.labelAnnotation == null) {
            this.labelAnnotation = OWLRDFVocabulary.RDFS_LABEL.getIRI();
        }
        this.annotationURILabel.setText(this.labelAnnotation.toString());
        this.annotationURILabel.setEditable(false);
        panel.add((Component)this.annotationURILabel, c);
        c.gridx = 2;
        c.fill = 0;
        c.insets = new Insets(5, 5, 0, 12);
        c.weightx = 0.0;
        this.annotationSelectButton = new JButton(new AbstractAction("..."){
            private static final long serialVersionUID = 7759812643136092837L;

            public void actionPerformed(ActionEvent event) {
                NewEntitiesPreferencesPanel.this.handleSelectAnnotation();
            }
        });
        panel.add((Component)this.annotationSelectButton, c);
        c.gridx = 0;
        c.gridy = 5;
        c.insets = new Insets(5, 30, 12, 5);
        this.langLabel = new JLabel("Lang");
        panel.add((Component)this.langLabel, c);
        c.gridx = 1;
        c.insets = new Insets(5, 0, 12, 0);
        c.weighty = 1.0;
        this.annotationLangSelector = new UIHelper(this.getOWLEditorKit()).getLanguageSelector();
        this.annotationLangSelector.setSelectedItem(EntityCreationPreferences.getNameLabelLang());
        panel.add((Component)this.annotationLangSelector, c);
        return panel;
    }

    private JPanel createAutoGeneratedIDPanel() {
        this.autoGeneratedIDPanel = new JPanel();
        this.autoGeneratedIDPanel.setLayout(new FlowLayout(3));
        this.autoGeneratedIDPanel.setBorder(new TitledBorder("Auto-generated ID"));
        JPanel interiorPanel = new JPanel(new BorderLayout(32, 0));
        interiorPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 0, 0));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 3));
        this.pseudoRandomButton = new JRadioButton("Numeric (pseudo random)");
        this.iterativeButton = new JRadioButton("Numeric (iterative)");
        this.uniqueIdButton = new JRadioButton("Unique and meaningless");
        Class<? extends AutoIDGenerator> autoIDGenCls = EntityCreationPreferences.getAutoIDGeneratorClass();
        this.pseudoRandomButton.setSelected(autoIDGenCls.equals(PseudoRandomAutoIDGenerator.class));
        this.iterativeButton.setSelected(autoIDGenCls.equals(IterativeAutoIDGenerator.class));
        this.uniqueIdButton.setSelected(autoIDGenCls.equals(UniqueIdGenerator.class));
        ButtonGroup group = new ButtonGroup();
        group.add(this.pseudoRandomButton);
        group.add(this.iterativeButton);
        group.add(this.uniqueIdButton);
        this.pseudoRandomButton.addActionListener(this);
        this.iterativeButton.addActionListener(this);
        this.uniqueIdButton.addActionListener(this);
        leftPanel.add(this.pseudoRandomButton);
        leftPanel.add(this.iterativeButton);
        leftPanel.add(this.uniqueIdButton);
        leftPanel.add(Box.createVerticalGlue());
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 0);
        c.anchor = 22;
        this.prefixLabel = new JLabel("Prefix: ");
        centerPanel.add((Component)this.prefixLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 23;
        this.autoIDPrefix = new JTextField();
        this.autoIDPrefix.setText(EntityCreationPreferences.getPrefix());
        this.autoIDPrefix.setColumns(30);
        centerPanel.add((Component)this.autoIDPrefix, c);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 22;
        this.suffixLabel = new JLabel("Suffix: ");
        centerPanel.add((Component)this.suffixLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 23;
        this.autoIDSuffix = new JTextField();
        this.autoIDSuffix.setText(EntityCreationPreferences.getSuffix());
        this.autoIDSuffix.setColumns(30);
        centerPanel.add((Component)this.autoIDSuffix, c);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 22;
        this.digitCountLabel = new JLabel("Digit count: ");
        centerPanel.add((Component)this.digitCountLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 23;
        c.weightx = 0.5;
        this.autoIDDigitCount = new JSpinner(new SpinnerNumberModel(6, 0, 255, 1));
        this.autoIDDigitCount.setValue(EntityCreationPreferences.getAutoIDDigitCount());
        this.autoIDDigitCount.setPreferredSize(new Dimension(100, 20));
        centerPanel.add((Component)this.autoIDDigitCount, c);
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 0.0;
        c.anchor = 22;
        this.startLabel = new JLabel("Start: ");
        this.startLabel.setEnabled(this.iterativeButton.isSelected());
        centerPanel.add((Component)this.startLabel, c);
        c.gridx = 1;
        c.gridy = 3;
        c.anchor = 23;
        this.autoIDStart = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        this.autoIDStart.setPreferredSize(new Dimension(100, 20));
        this.autoIDStart.setValue(EntityCreationPreferences.getAutoIDStart());
        this.autoIDStart.setEnabled(this.iterativeButton.isSelected());
        this.autoIDStart.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                if ((Integer)NewEntitiesPreferencesPanel.this.autoIDEnd.getValue() != -1 && (Integer)NewEntitiesPreferencesPanel.this.autoIDEnd.getValue() <= (Integer)NewEntitiesPreferencesPanel.this.autoIDStart.getValue()) {
                    NewEntitiesPreferencesPanel.this.autoIDEnd.setValue(NewEntitiesPreferencesPanel.this.autoIDStart.getValue());
                }
            }
        });
        centerPanel.add((Component)this.autoIDStart, c);
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 22;
        this.endLabel = new JLabel("End: ");
        this.endLabel.setEnabled(this.iterativeButton.isSelected());
        centerPanel.add((Component)this.endLabel, c);
        c.gridx = 1;
        c.gridy = 4;
        c.anchor = 23;
        this.autoIDEnd = new JSpinner(new SpinnerNumberModel(-1, -1, Integer.MAX_VALUE, 1));
        this.autoIDEnd.setPreferredSize(new Dimension(100, 20));
        this.autoIDEnd.setValue(EntityCreationPreferences.getAutoIDEnd());
        this.autoIDEnd.setEnabled(this.iterativeButton.isSelected());
        this.autoIDEnd.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                if ((Integer)NewEntitiesPreferencesPanel.this.autoIDEnd.getValue() != -1 && (Integer)NewEntitiesPreferencesPanel.this.autoIDEnd.getValue() <= (Integer)NewEntitiesPreferencesPanel.this.autoIDStart.getValue()) {
                    NewEntitiesPreferencesPanel.this.autoIDStart.setValue(NewEntitiesPreferencesPanel.this.autoIDEnd.getValue());
                }
            }
        });
        centerPanel.add((Component)this.autoIDEnd, c);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 2;
        c.fill = 2;
        c.weighty = 1.0;
        this.saveIterativeIds = new JCheckBox("Remember last ID between Prot\u00e9g\u00e9 sessions");
        this.saveIterativeIds.setSelected(EntityCreationPreferences.getSaveAutoIDStart());
        this.saveIterativeIds.setEnabled(this.iterativeButton.isSelected());
        centerPanel.add((Component)this.saveIterativeIds, c);
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        centerPanel.add(new JLabel(""));
        if (this.autoIDURIFragment.isSelected() || this.autoIDLabel.isSelected() && this.autoIDLabel.isEnabled()) {
            this.enableAutoGeneratedIDPanel(true);
        } else {
            this.enableAutoGeneratedIDPanel(false);
        }
        interiorPanel.add((Component)leftPanel, "Before");
        interiorPanel.add((Component)centerPanel, "Center");
        this.autoGeneratedIDPanel.add(interiorPanel);
        return this.autoGeneratedIDPanel;
    }

    private void enableAutoGeneratedIDPanel(boolean b) {
        this.autoIDDigitCount.setEnabled(b);
        this.autoIDEnd.setEnabled(b);
        this.autoIDPrefix.setEnabled(b);
        this.autoIDStart.setEnabled(b);
        this.autoIDSuffix.setEnabled(b);
        this.autoGeneratedIDPanel.setEnabled(b);
        this.digitCountLabel.setEnabled(b);
        this.endLabel.setEnabled(b);
        this.iterativeButton.setEnabled(b);
        this.prefixLabel.setEnabled(b);
        this.pseudoRandomButton.setEnabled(b);
        this.saveIterativeIds.setEnabled(b);
        this.startLabel.setEnabled(b);
        this.suffixLabel.setEnabled(b);
        this.uniqueIdButton.setEnabled(b);
        this.enableNumericIterativeOptions(this.iterativeButton.isSelected() && this.iterativeButton.isEnabled());
    }

    private void enableNumericIterativeOptions(boolean b) {
        this.startLabel.setEnabled(b);
        this.autoIDStart.setEnabled(b);
        this.endLabel.setEnabled(b);
        this.autoIDEnd.setEnabled(b);
        this.saveIterativeIds.setEnabled(b);
    }

    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object == this.iterativeButton) {
            this.enableNumericIterativeOptions(true);
        } else if (object == this.pseudoRandomButton || object == this.uniqueIdButton) {
            this.enableNumericIterativeOptions(false);
        }
    }

    public void applyChanges() {
        EntityCreationPreferences.setUseDefaultBaseIRI(this.uriBaseSpecifiedURI.isSelected());
        try {
            IRI defaultBase = IRI.create((URI)new URI(this.uriDefaultBaseField.getText()));
            EntityCreationPreferences.setDefaultBaseIRI(defaultBase);
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)("Ignoring invalid base URI (" + this.uriDefaultBaseField.getText() + ")"));
        }
        if (this.hashButton.isSelected()) {
            EntityCreationPreferences.setDefaultSeparator(SEP_HASH);
        } else if (this.slashButton.isSelected()) {
            EntityCreationPreferences.setDefaultSeparator(SEP_SLASH);
        } else if (this.colonButton.isSelected()) {
            EntityCreationPreferences.setDefaultSeparator(SEP_COLON);
        }
        EntityCreationPreferences.setFragmentAutoGenerated(this.autoIDURIFragment.isSelected());
        EntityCreationPreferences.setGenerateNameLabel(this.nameAsLabel.isSelected());
        EntityCreationPreferences.setGenerateIDLabel(this.autoIDLabel.isSelected());
        if (this.sameAsRendererLabelButton.isSelected()) {
            EntityCreationPreferences.setLabelDescriptorClass(MatchRendererLabelDescriptor.class);
        }
        if (this.customLabelButton.isSelected()) {
            EntityCreationPreferences.setLabelDescriptorClass(CustomLabelDescriptor.class);
        }
        EntityCreationPreferences.setNameLabelIRI(IRI.create((String)this.annotationURILabel.getText()));
        Object lang = this.annotationLangSelector.getSelectedItem();
        if (lang != null && !lang.equals("")) {
            EntityCreationPreferences.setNameLabelLang((String)lang);
        } else {
            EntityCreationPreferences.setNameLabelLang(null);
        }
        if (this.pseudoRandomButton.isSelected()) {
            EntityCreationPreferences.setAutoIDGeneratorClass(PseudoRandomAutoIDGenerator.class);
        }
        if (this.iterativeButton.isSelected()) {
            EntityCreationPreferences.setAutoIDGeneratorClass(IterativeAutoIDGenerator.class);
        }
        if (this.uniqueIdButton.isSelected()) {
            EntityCreationPreferences.setAutoIDGeneratorClass(UniqueIdGenerator.class);
        }
        EntityCreationPreferences.setAutoIDStart((Integer)this.autoIDStart.getValue());
        EntityCreationPreferences.setAutoIDEnd((Integer)this.autoIDEnd.getValue());
        EntityCreationPreferences.setAutoIDDigitCount((Integer)this.autoIDDigitCount.getValue());
        EntityCreationPreferences.setPrefix(this.autoIDPrefix.getText());
        EntityCreationPreferences.setSuffix(this.autoIDSuffix.getText());
        EntityCreationPreferences.setSaveAutoIDStart(this.saveIterativeIds.isSelected());
    }

    private void handleActionCreateLabelFromID() {
        if (this.autoIDLabel.isSelected()) {
            this.enableAutoGeneratedIDPanel(true);
        } else if (!this.autoIDURIFragment.isSelected()) {
            this.enableAutoGeneratedIDPanel(false);
        }
    }

    private void handleActionEndWithID() {
        boolean selected = this.autoIDURIFragment.isSelected();
        this.enableAutoGeneratedIDPanel(selected);
        this.nameAsLabel.setEnabled(!selected);
    }

    private void handleActionEndWithName() {
        boolean selected = this.nameAsURIFragment.isSelected();
        if (selected && !this.autoIDLabel.isSelected()) {
            this.enableAutoGeneratedIDPanel(false);
        }
        this.nameAsLabel.setEnabled(selected);
    }

    protected void handleSelectAnnotation() {
        OWLAnnotationProperty prop = new UIHelper(this.getOWLEditorKit()).pickAnnotationProperty();
        if (prop != null) {
            this.labelAnnotation = prop.getIRI();
            this.annotationURILabel.setText(this.labelAnnotation.toString());
        }
    }

    public IRI getFirstRendererLabel() {
        List<IRI> iris = OWLRendererPreferences.getInstance().getAnnotationIRIs();
        if (!iris.isEmpty()) {
            return iris.get(0);
        }
        return OWLRDFVocabulary.RDFS_LABEL.getIRI();
    }

    public void dispose() throws Exception {
    }
}

