/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.preferences;

import java.awt.Container;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.model.XMLWriterPrefs;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;

public class SavePreferencesPanel
extends OWLPreferencesPanel {
    private static final int VERTICAL_SPACE = 20;
    private JCheckBox useXMLEntitiesCheckBox;
    private JCheckBox writeTemporaryFilesCheckBox;

    public void initialise() throws Exception {
        this.setLayout(new BoxLayout((Container)((Object)this), 3));
        this.writeTemporaryFilesCheckBox = new JCheckBox("Write temporary files when saving");
        this.writeTemporaryFilesCheckBox.setSelected(this.getFilePrefs().getBoolean("ENABLE_TEMP_DIRECTORIES_KEY", true));
        JComponent xmlWriterPanel = this.createPane("XML Writer", 3);
        this.useXMLEntitiesCheckBox = new JCheckBox("Use XML Entities");
        this.useXMLEntitiesCheckBox.setSelected(XMLWriterPrefs.getInstance().isUseEntities());
        xmlWriterPanel.add(this.useXMLEntitiesCheckBox);
        this.add(this.writeTemporaryFilesCheckBox);
        this.add(Box.createVerticalStrut(20));
        this.add(xmlWriterPanel);
    }

    public void applyChanges() {
        XMLWriterPrefs.getInstance().setUseEntities(this.useXMLEntitiesCheckBox.isSelected());
        this.getFilePrefs().putBoolean("ENABLE_TEMP_DIRECTORIES_KEY", this.writeTemporaryFilesCheckBox.isSelected());
    }

    public void dispose() throws Exception {
    }

    private JComponent createPane(String title, int orientation) {
        Box c = new Box(orientation){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
            }
        };
        c.setAlignmentX(0.0f);
        if (title != null) {
            c.setBorder(ComponentFactory.createTitledBorder((String)title));
        }
        return c;
    }

    private Preferences getFilePrefs() {
        return PreferencesManager.getInstance().getApplicationPreferences("FILE_PREFERENCES_KEY");
    }
}

