/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import java.awt.BorderLayout;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.prefix.PrefixMapperTable;
import org.protege.editor.owl.ui.prefix.PrefixUtilities;
import org.protege.editor.owl.ui.renderer.OWLModelManagerEntityRenderer;
import org.protege.editor.owl.ui.renderer.prefix.PrefixBasedRenderer;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

public class PrefixMapperTables
extends JPanel {
    private static final long serialVersionUID = -7430862544150495635L;
    private PrefixMapperTable table;
    private OWLOntology ontology;
    private OWLModelManager modelManager;
    private Set<SelectedOntologyListener> listeners = new HashSet<SelectedOntologyListener>();
    private TableModelListener editListener = new TableModelListener(){

        public void tableChanged(TableModelEvent e) {
            if (PrefixMapperTables.this.table != null && PrefixMapperTables.this.table.getModel().commitPrefixes()) {
                PrefixMapperTables.this.modelManager.setDirty(PrefixMapperTables.this.ontology);
                OWLModelManagerEntityRenderer renderer = PrefixMapperTables.this.modelManager.getOWLEntityRenderer();
                if (renderer instanceof PrefixBasedRenderer) {
                    PrefixMapperTables.this.modelManager.refreshRenderer();
                }
            }
        }
    };

    public PrefixMapperTables(OWLModelManager modelManager) {
        this.modelManager = modelManager;
        this.setLayout(new BorderLayout());
        this.setOntology(modelManager.getActiveOntology());
    }

    public void refill() {
        this.table.getModel().refill();
    }

    public void setOntology(OWLOntology ontology) {
        if (this.table != null) {
            this.table.getModel().removeTableModelListener(this.editListener);
        }
        this.ontology = ontology;
        PrefixOWLOntologyFormat prefixManager = PrefixUtilities.getPrefixOWLOntologyFormat(ontology);
        this.table = new PrefixMapperTable(prefixManager);
        this.table.getModel().addTableModelListener(this.editListener);
        this.removeAll();
        this.add(new JScrollPane(this.table));
        for (SelectedOntologyListener listener : this.listeners) {
            listener.selectedOntologyChanged();
        }
    }

    public void addListener(SelectedOntologyListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SelectedOntologyListener listener) {
        this.listeners.remove(listener);
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public PrefixMapperTable getPrefixMapperTable() {
        return this.table;
    }

    public static interface SelectedOntologyListener {
        public void selectedOntologyChanged();
    }
}

