/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.rename;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.Logger;
import org.protege.editor.core.ui.util.CheckTable;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.find.OWLEntityFinderPreferences;
import org.protege.editor.owl.model.refactor.EntityFindAndReplaceURIRenamer;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.renderer.OWLModelManagerEntityRenderer;
import org.protege.editor.owl.ui.renderer.RenderingEscapeUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameEntitiesPanel
extends JPanel
implements VerifiedInputEditor {
    private Logger logger = Logger.getLogger(RenameEntitiesPanel.class);
    private static final int SEARCH_PAUSE_MILLIS = 1000;
    private OWLEditorKit eKit;
    private Map<String, Set<OWLEntity>> nsMap = new HashMap<String, Set<OWLEntity>>();
    private JComboBox replaceWithCombo;
    private JComboBox findCombo;
    private CheckTable<OWLEntity> list;
    private OWLModelManagerEntityRenderer fragRenderer;
    private Set<OWLEntity> errors = Collections.emptySet();
    private EntityFindAndReplaceURIRenamer renamer;
    private ItemListener findListener = new ItemListener(){

        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                RenameEntitiesPanel.this.reloadEntityListThreaded();
            }
        }
    };
    private ItemListener replaceListener = new ItemListener(){

        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                RenameEntitiesPanel.this.updateErrors();
                RenameEntitiesPanel.this.handleStateChanged();
            }
        }
    };
    private ListSelectionListener listSelListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent event) {
            RenameEntitiesPanel.this.updateErrors();
            RenameEntitiesPanel.this.handleStateChanged();
        }
    };
    private List<InputVerificationStatusChangedListener> statusListeners = new ArrayList<InputVerificationStatusChangedListener>();
    private boolean currentStatus = false;
    private Thread reloadThread;
    private Runnable reloadProcess = new Runnable(){

        public void run() {
            RenameEntitiesPanel.this.reloadEntityList();
            RenameEntitiesPanel.this.reloadThread = null;
        }
    };

    public RenameEntitiesPanel(OWLEditorKit eKit) {
        this.setLayout(new BorderLayout(6, 6));
        this.eKit = eKit;
        this.refreshMap();
        JPanel subPanel = new JPanel();
        subPanel.setBorder(new TitledBorder("Find & Replace"));
        subPanel.setLayout(new BorderLayout());
        this.findCombo = this.createCombo("Find", this.findListener, subPanel, "North");
        this.replaceWithCombo = this.createCombo("Replace with", this.replaceListener, subPanel, "South");
        this.add((Component)subPanel, "North");
        this.list = new CheckTable("Matching entities");
        this.list.checkAll(true);
        this.list.setDefaultRenderer((TableCellRenderer)new ResultCellRenderer(eKit));
        this.list.addCheckSelectionListener(this.listSelListener);
        this.add((Component)new JScrollPane((Component)this.list), "Center");
    }

    private JComboBox createCombo(String title, ItemListener listener, JComponent parent, String constraints) {
        final JComboBox<Object> combo = new JComboBox<Object>(this.nsMap.keySet().toArray());
        combo.addItem("");
        combo.setSelectedItem("");
        combo.setEditable(true);
        combo.addItemListener(listener);
        final JTextComponent editor = (JTextComponent)combo.getEditor().getEditorComponent();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                combo.setSelectedItem(editor.getText());
            }
        };
        final Timer timer = new Timer(1000, actionListener);
        editor.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent event) {
                timer.restart();
            }

            public void removeUpdate(DocumentEvent event) {
                timer.restart();
            }

            public void changedUpdate(DocumentEvent event) {
            }
        });
        JPanel panel = new JPanel(new FlowLayout(2));
        panel.add(new JLabel(title));
        panel.add(combo);
        parent.add((Component)panel, constraints);
        return combo;
    }

    public String getFindValue() {
        return (String)this.findCombo.getSelectedItem();
    }

    public String getReplaceWithValue() {
        return (String)this.replaceWithCombo.getSelectedItem();
    }

    public List<OWLEntity> getSelectedEntities() {
        return this.list.getFilteredValues();
    }

    public EntityFindAndReplaceURIRenamer getRenamer() {
        return this.renamer;
    }

    private void reloadEntityList() {
        ArrayList<OWLEntity> sortedEntities = new ArrayList<OWLEntity>(this.getEntities());
        Collections.sort(sortedEntities, this.eKit.getModelManager().getOWLObjectComparator());
        this.list.getModel().setData(sortedEntities, true);
        this.updateErrors();
        this.handleStateChanged();
    }

    private Set<OWLEntity> getEntities() {
        Set<OWLEntity> matches = this.nsMap.get(this.getFindValue());
        if (matches == null) {
            matches = new HashSet<OWLEntity>();
            HashSet ents = new HashSet();
            for (OWLOntology ont : this.getOntologies()) {
                ents.addAll(ont.getSignature());
            }
            OWLEntityFinderPreferences prefs = OWLEntityFinderPreferences.getInstance();
            String matchingVal = this.getFindValue();
            if (!prefs.isUseRegularExpressions()) {
                matchingVal = "(?i).*" + matchingVal + ".*";
            }
            Pattern p = Pattern.compile(matchingVal);
            for (OWLEntity ent : ents) {
                if (!p.matcher(ent.getIRI().toString()).matches()) continue;
                matches.add(ent);
            }
        }
        return matches;
    }

    private Set<OWLOntology> getOntologies() {
        return this.eKit.getModelManager().getOntologies();
    }

    private void updateErrors() {
        OWLModelManager mngr = this.eKit.getModelManager();
        this.renamer = new EntityFindAndReplaceURIRenamer(mngr.getOWLOntologyManager(), this.list.getFilteredValues(), this.getOntologies(), this.getFindValue(), this.getReplaceWithValue());
        this.errors = this.renamer.getErrors().keySet();
        this.list.repaint();
    }

    private void refreshMap() {
        for (OWLOntology ont : this.getOntologies()) {
            for (OWLEntity entity : ont.getSignature()) {
                this.extractNSFromEntity(entity);
            }
        }
    }

    private void extractNSFromEntity(OWLEntity entity) {
        String ns = this.getBase(entity.getIRI());
        Set<OWLEntity> matchingEntities = this.nsMap.get(ns);
        if (matchingEntities == null) {
            matchingEntities = new HashSet<OWLEntity>();
        }
        matchingEntities.add(entity);
        this.nsMap.put(ns, matchingEntities);
    }

    private String getBase(IRI uri) {
        String uriStr;
        String frag = this.getShortForm(uri);
        try {
            uriStr = URLDecoder.decode(uri.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (frag.startsWith("'")) {
            frag = frag.substring(1, frag.length() - 1);
        }
        return uriStr.substring(0, uriStr.lastIndexOf(frag));
    }

    private String getShortForm(IRI uri) {
        try {
            String rendering = uri.getFragment();
            if (rendering == null) {
                String path = uri.toURI().getPath();
                if (path == null) {
                    return uri.toString();
                }
                return uri.toURI().getPath().substring(path.lastIndexOf("/") + 1);
            }
            return RenderingEscapeUtils.getEscapedRendering(rendering);
        }
        catch (Exception e) {
            return "<Error! " + e.getMessage() + ">";
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.statusListeners.add(listener);
        listener.verifiedStatusChanged(this.currentStatus);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.statusListeners.remove(listener);
    }

    private void handleStateChanged() {
        boolean valid = this.getStatus();
        if (this.currentStatus != valid) {
            this.currentStatus = valid;
            for (InputVerificationStatusChangedListener l : this.statusListeners) {
                l.verifiedStatusChanged(this.currentStatus);
            }
        }
    }

    private boolean getStatus() {
        return this.findCombo.getSelectedItem() != null && !this.findCombo.getSelectedItem().equals("") && this.replaceWithCombo.getSelectedItem() != null && !this.replaceWithCombo.getSelectedItem().equals("") && !this.list.getFilteredValues().isEmpty() && this.errors.isEmpty();
    }

    private void reloadEntityListThreaded() {
        if (this.reloadThread != null && this.reloadThread.isAlive()) {
            this.reloadThread.interrupt();
        }
        this.reloadThread = new Thread(this.reloadProcess);
        this.reloadThread.run();
    }

    public JComponent getFocusComponent() {
        return (JComponent)this.findCombo.getEditor().getEditorComponent();
    }

    class ResultCellRenderer
    extends OWLCellRenderer {
        private boolean inURI;
        private Style fadedStyle;
        private Style highlightedStyle;

        public ResultCellRenderer(OWLEditorKit owlEditorKit) {
            super(owlEditorKit);
            this.inURI = false;
            this.fadedStyle = null;
            this.highlightedStyle = null;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (RenameEntitiesPanel.this.errors.contains(value)) {
                this.setStrikeThrough(true);
            } else {
                this.setStrikeThrough(false);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        protected String getRendering(Object object) {
            if (object instanceof OWLEntity) {
                return super.getRendering(object) + " (" + ((OWLEntity)object).getIRI() + ")";
            }
            return super.getRendering(object);
        }

        protected void renderToken(String curToken, int tokenStartIndex, StyledDocument doc) {
            super.renderToken(curToken, tokenStartIndex, doc);
            if (RenameEntitiesPanel.this.logger.isDebugEnabled()) {
                RenameEntitiesPanel.this.logger.debug((Object)("curToken = " + curToken));
            }
            if (curToken.startsWith("(")) {
                this.inURI = true;
            }
            if (curToken.equals(")")) {
                this.inURI = false;
            } else if (this.inURI) {
                if (this.fadedStyle == null) {
                    this.fadedStyle = doc.addStyle("MY_FADED_STYLE", null);
                    StyleConstants.setForeground(this.fadedStyle, Color.GRAY);
                }
                doc.setCharacterAttributes(tokenStartIndex, doc.getLength() - tokenStartIndex, this.fadedStyle, false);
                if (this.highlightedStyle == null) {
                    this.highlightedStyle = doc.addStyle("MY_HIGHLIGHTED_STYLE", null);
                    StyleConstants.setForeground(this.highlightedStyle, Color.darkGray);
                    StyleConstants.setBold(this.highlightedStyle, true);
                }
                String s = RenameEntitiesPanel.this.getFindValue().toLowerCase();
                curToken = curToken.toLowerCase();
                int cur = 0;
                do {
                    if ((cur = curToken.indexOf(s, cur)) == -1) continue;
                    doc.setCharacterAttributes(tokenStartIndex + cur, s.length(), this.highlightedStyle, true);
                    ++cur;
                } while (cur != -1);
            }
        }
    }
}

