/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.protege.editor.core.ui.util.Icons;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;

public class AnnotationRendererPanel
extends JPanel {
    private static final long serialVersionUID = -4986709925668660394L;
    private JTable table;
    private JToolBar toolbar;
    private DefaultTableModel model;
    private JTextField languageField;
    private boolean dirty = false;
    private OWLEditorKit eKit;
    private Action addAction = new AbstractAction("Add Annotation", OWLIcons.getIcon("property.annotation.add.png")){

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationRendererPanel.this.handleAddAnnotation();
        }
    };
    private Action removeAction = new AbstractAction("Remove Annotation", OWLIcons.getIcon("property.annotation.remove.png")){

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationRendererPanel.this.handleRemoveAnnotation();
        }
    };
    private Action upAction = new AbstractAction("Move Up", Icons.getIcon((String)"object.move_up.gif")){

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationRendererPanel.this.handleMoveUp();
        }
    };
    private Action downAction = new AbstractAction("Move Down", Icons.getIcon((String)"object.move_down.gif")){

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationRendererPanel.this.handleMoveDown();
        }
    };

    public AnnotationRendererPanel(OWLEditorKit owlEditorKit) {
        this.eKit = owlEditorKit;
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.addToolbarAction(this.addAction);
        this.addToolbarAction(this.removeAction);
        this.toolbar.addSeparator(new Dimension(6, 6));
        this.addToolbarAction(this.upAction);
        this.addToolbarAction(this.downAction);
        this.add((Component)this.toolbar, "North");
        this.model = new DefaultTableModel(){

            public boolean isCellEditable(int row, int col) {
                return col > 0;
            }
        };
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                AnnotationRendererPanel.this.dirty = true;
            }
        });
        this.model.addColumn("Annotation IRI");
        this.table = new JTable(this.model);
        this.table.setShowVerticalLines(false);
        this.table.setAutoResizeMode(2);
        this.table.getColumnModel().getColumn(0).setWidth(200);
        JScrollPane scroller = new JScrollPane(this.table);
        this.add((Component)scroller, "Center");
        JPanel languagePanel = new JPanel();
        languagePanel.setLayout(new BoxLayout(languagePanel, 0));
        languagePanel.add(new JLabel("Set Language: "));
        this.languageField = new JTextField();
        languagePanel.add(this.languageField);
        this.add((Component)languagePanel, "South");
        this.load();
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 500);
    }

    public static boolean showDialog(OWLEditorKit owlEditorKit) {
        AnnotationRendererPanel panel = new AnnotationRendererPanel(owlEditorKit);
        int ret = JOptionPaneEx.showConfirmDialog((Component)((Object)owlEditorKit.getWorkspace()), (String)"Annotation Renderer", (JComponent)panel, (int)-1, (int)2, (JComponent)panel);
        if (ret == 0) {
            panel.applyChanges();
            return true;
        }
        return false;
    }

    protected void load() {
        List<IRI> rows = OWLRendererPreferences.getInstance().getAnnotationIRIs();
        List<String> languages = OWLRendererPreferences.getInstance().getAnnotationLangs();
        for (IRI row : rows) {
            Object[] rowData = new Object[]{row};
            this.model.addRow(rowData);
        }
        StringBuilder langsAsString = new StringBuilder();
        for (String lang : languages) {
            if (langsAsString.length() != 0) {
                langsAsString.append(", ");
            }
            if (lang == "") {
                lang = "!";
            }
            langsAsString.append(lang);
        }
        if (langsAsString.length() > 1) {
            this.languageField.setText(langsAsString.toString());
        }
    }

    protected void applyChanges() {
        if (this.dirty) {
            ArrayList<IRI> iris = new ArrayList<IRI>();
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                IRI iri = (IRI)this.model.getValueAt(i, 0);
                iris.add(iri);
            }
            String langsAsString = this.languageField.getText();
            ArrayList<String> langs = new ArrayList<String>();
            if (langsAsString != null) {
                for (String token : langsAsString.split(",")) {
                    if ((token = token.trim()).equals("!")) {
                        token = "";
                    }
                    langs.add(token);
                }
            }
            OWLRendererPreferences.getInstance().setAnnotations(iris);
            OWLRendererPreferences.getInstance().setAnnotationLanguages(langs);
            this.dirty = false;
        }
    }

    private void addToolbarAction(Action action) {
        JButton button = new JButton(action);
        button.setToolTipText((String)action.getValue("Name"));
        button.setText(null);
        button.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.toolbar.add(button);
    }

    public void dispose() throws Exception {
    }

    private void handleAddAnnotation() {
        OWLAnnotationProperty p = new UIHelper(this.eKit).pickAnnotationProperty();
        if (p != null) {
            Object[] rowData = new Object[]{p.getIRI(), null};
            this.model.addRow(rowData);
            this.table.getSelectionModel().setSelectionInterval(this.model.getRowCount() - 1, this.model.getRowCount() - 1);
        }
    }

    private void handleRemoveAnnotation() {
        int row = this.table.getSelectedRow();
        if (row != -1) {
            this.model.removeRow(row);
            if (row < this.model.getRowCount()) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
            } else if (row - 1 > 0) {
                this.table.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private void handleMoveUp() {
        int row = this.table.getSelectedRow();
        if (row > 0) {
            this.model.moveRow(row, row, row - 1);
            this.table.getSelectionModel().setSelectionInterval(row - 1, row - 1);
        }
    }

    private void handleMoveDown() {
        int row = this.table.getSelectedRow();
        if (row < this.model.getRowCount() - 1) {
            this.model.moveRow(row, row, row + 1);
            this.table.getSelectionModel().setSelectionInterval(row + 1, row + 1);
        }
    }
}

