/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.tree.TreeCellRenderer;
import org.apache.log4j.Logger;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.model.util.OWLUtilities;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.renderer.LinkedObjectComponent;
import org.protege.editor.owl.ui.renderer.OWLEntityColorProvider;
import org.protege.editor.owl.ui.renderer.OWLEntityColorProviderPlugin;
import org.protege.editor.owl.ui.renderer.OWLEntityColorProviderPluginLoader;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLCellRenderer
implements TableCellRenderer,
TreeCellRenderer,
ListCellRenderer {
    private static final Logger logger = Logger.getLogger(OWLCellRenderer.class);
    private final Icon deprecatedIcon = OWLIcons.getIcon("Deprecated.gif");
    private boolean forceReadOnlyRendering;
    private OWLEditorKit owlEditorKit;
    private boolean renderIcon;
    private boolean renderExpression;
    private boolean strikeThrough;
    private OWLOntology ontology;
    private Set<OWLObject> equivalentObjects;
    private LinkedObjectComponent linkedObjectComponent;
    private Font plainFont;
    private Font boldFont;
    public static final Color SELECTION_BACKGROUND = UIManager.getDefaults().getColor("List.selectionBackground");
    public static final Color SELECTION_FOREGROUND = UIManager.getDefaults().getColor("List.selectionForeground");
    public static final Color FOREGROUND = UIManager.getDefaults().getColor("List.foreground");
    private boolean gettingCellBounds;
    private List<OWLEntityColorProvider> entityColorProviders;
    private OWLObject iconObject;
    private int leftMargin = 0;
    private int rightMargin = 40;
    private JComponent componentBeingRendered;
    private JPanel renderingComponent;
    private JLabel iconLabel;
    private JTextPane textPane;
    private JLabel deprecatedLabel;
    private int preferredWidth;
    private int minTextHeight;
    private OWLEntity focusedEntity;
    private boolean commentedOut;
    private boolean inferred;
    private boolean highlightKeywords;
    private boolean wrap = true;
    private boolean highlightUnsatisfiableClasses = true;
    private boolean highlightUnsatisfiableProperties = true;
    private Set<OWLEntity> crossedOutEntities;
    private Set<String> unsatisfiableNames;
    private Set<String> boxedNames;
    private int plainFontHeight;
    private boolean opaque = false;
    private boolean renderLinks;
    private ActiveEntityVisitor activeEntityVisitor = new ActiveEntityVisitor();
    private Composite disabledComposite = AlphaComposite.getInstance(3, 0.5f);
    private Style plainStyle;
    private Style boldStyle;
    private Style nonBoldStyle;
    private Style selectionForeground;
    private Style foreground;
    private Style linkStyle;
    private Style inconsistentClassStyle;
    private Style focusedEntityStyle;
    private Style ontologyURIStyle;
    private Style commentedOutStyle;
    private Style strikeOutStyle;
    private Style fontSizeStyle;
    private boolean annotURIRendered = false;
    private boolean linkRendered = false;
    private boolean parenthesisRendered = false;

    public OWLCellRenderer(OWLEditorKit owlEditorKit) {
        this(owlEditorKit, true, true);
    }

    public OWLCellRenderer(OWLEditorKit owlEditorKit, boolean renderExpression, boolean renderIcon) {
        this.owlEditorKit = owlEditorKit;
        this.renderExpression = renderExpression;
        this.renderIcon = renderIcon;
        this.equivalentObjects = new HashSet<OWLObject>();
        this.iconLabel = new JLabel("");
        this.iconLabel.setOpaque(false);
        this.iconLabel.setVerticalAlignment(0);
        this.textPane = new JTextPane();
        this.textPane.setOpaque(false);
        this.deprecatedLabel = new JLabel("");
        this.deprecatedLabel.setOpaque(false);
        this.deprecatedLabel.setVerticalAlignment(0);
        this.renderingComponent = new JPanel(new OWLCellRendererLayoutManager());
        this.renderingComponent.add(this.iconLabel);
        this.renderingComponent.add(this.textPane);
        this.renderingComponent.add(this.deprecatedLabel);
        this.entityColorProviders = new ArrayList<OWLEntityColorProvider>();
        OWLEntityColorProviderPluginLoader loader = new OWLEntityColorProviderPluginLoader(this.getOWLModelManager());
        for (OWLEntityColorProviderPlugin plugin : loader.getPlugins()) {
            try {
                OWLEntityColorProvider prov = (OWLEntityColorProvider)plugin.newInstance();
                prov.initialise();
                this.entityColorProviders.add(prov);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        this.crossedOutEntities = new HashSet<OWLEntity>();
        this.unsatisfiableNames = new HashSet<String>();
        this.boxedNames = new HashSet<String>();
        this.prepareStyles();
        this.setupFont();
    }

    public void setForceReadOnlyRendering(boolean forceReadOnlyRendering) {
        this.forceReadOnlyRendering = forceReadOnlyRendering;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public void setUnsatisfiableNames(Set<String> unsatisfiableNames) {
        this.unsatisfiableNames.clear();
        this.unsatisfiableNames.addAll(unsatisfiableNames);
    }

    public void setHighlightKeywords(boolean hightlighKeywords) {
        this.highlightKeywords = hightlighKeywords;
    }

    public void setHighlightUnsatisfiableClasses(boolean highlightUnsatisfiableClasses) {
        this.highlightUnsatisfiableClasses = highlightUnsatisfiableClasses;
    }

    public void setHighlightUnsatisfiableProperties(boolean highlightUnsatisfiableProperties) {
        this.highlightUnsatisfiableProperties = highlightUnsatisfiableProperties;
    }

    public void setOntology(OWLOntology ont) {
        this.forceReadOnlyRendering = false;
        this.ontology = ont;
    }

    public void setIconObject(OWLObject object) {
        this.iconObject = object;
    }

    public void setCrossedOutEntities(Set<OWLEntity> entities) {
        this.crossedOutEntities.addAll(entities);
    }

    public void addBoxedName(String name) {
        this.boxedNames.add(name);
    }

    public boolean isBoxedName(String name) {
        return this.boxedNames.contains(name);
    }

    public void reset() {
        this.iconObject = null;
        this.rightMargin = 0;
        this.ontology = null;
        this.focusedEntity = null;
        this.commentedOut = false;
        this.inferred = false;
        this.strikeThrough = false;
        this.highlightUnsatisfiableClasses = true;
        this.highlightUnsatisfiableProperties = true;
        this.crossedOutEntities.clear();
        this.unsatisfiableNames.clear();
        this.boxedNames.clear();
    }

    public void setFocusedEntity(OWLEntity entity) {
        this.focusedEntity = entity;
    }

    public void setEquivalentObjects(Set<OWLObject> objects) {
        this.equivalentObjects.clear();
        this.equivalentObjects.addAll(objects);
    }

    public void setInferred(boolean inferred) {
        this.inferred = inferred;
    }

    public void setStrikeThrough(boolean strikeThrough) {
        this.strikeThrough = strikeThrough;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    private void setupFont() {
        this.plainFont = OWLRendererPreferences.getInstance().getFont();
        this.plainFontHeight = this.iconLabel.getFontMetrics(this.plainFont).getHeight();
        this.boldFont = this.plainFont.deriveFont(1);
        this.textPane.setFont(this.plainFont);
    }

    protected int getFontSize() {
        return OWLRendererPreferences.getInstance().getFontSize();
    }

    public boolean isRenderExpression() {
        return this.renderExpression;
    }

    public boolean isRenderIcon() {
        return this.renderIcon;
    }

    public void setCommentedOut(boolean commentedOut) {
        this.commentedOut = commentedOut;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setupLinkedObjectComponent(table, table.getCellRect(row, column, true));
        this.preferredWidth = table.getParent().getWidth();
        this.componentBeingRendered = table;
        return this.prepareRenderer(value, isSelected, hasFocus);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.componentBeingRendered = tree;
        Rectangle cellBounds = new Rectangle();
        if (!this.gettingCellBounds) {
            this.gettingCellBounds = true;
            cellBounds = tree.getRowBounds(row);
            this.gettingCellBounds = false;
        }
        this.setupLinkedObjectComponent(tree, cellBounds);
        this.preferredWidth = -1;
        this.minTextHeight = 12;
        tree.setToolTipText(value != null ? value.toString() : "");
        Component c = this.prepareRenderer(value, selected, hasFocus);
        this.reset();
        return c;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.componentBeingRendered = list;
        Rectangle cellBounds = new Rectangle();
        if (!this.gettingCellBounds) {
            this.gettingCellBounds = true;
            cellBounds = list.getCellBounds(index, index);
            this.gettingCellBounds = false;
        }
        this.minTextHeight = 12;
        if (list.getParent() != null) {
            this.preferredWidth = list.getParent().getWidth();
        }
        this.setupLinkedObjectComponent(list, cellBounds);
        Component c = this.prepareRenderer(value, isSelected, cellHasFocus);
        this.reset();
        return c;
    }

    private void setupLinkedObjectComponent(JComponent component, Rectangle cellRect) {
        this.renderLinks = false;
        this.linkedObjectComponent = null;
        if (cellRect == null) {
            return;
        }
        if (component instanceof LinkedObjectComponent && OWLRendererPreferences.getInstance().isRenderHyperlinks()) {
            this.linkedObjectComponent = (LinkedObjectComponent)((Object)component);
            Point mouseLoc = component.getMousePosition(true);
            if (mouseLoc == null) {
                this.linkedObjectComponent.setLinkedObject(null);
                return;
            }
            this.renderLinks = cellRect.contains(mouseLoc);
        }
    }

    private Component prepareRenderer(Object value, boolean isSelected, boolean hasFocus) {
        this.renderingComponent.setOpaque(isSelected || this.opaque);
        if (value instanceof OWLEntity) {
            OWLEntity entity = (OWLEntity)value;
            OWLDeclarationAxiom declAx = this.getOWLModelManager().getOWLDataFactory().getOWLDeclarationAxiom(entity);
            if (this.getOWLModelManager().getActiveOntology().containsAxiom((OWLAxiom)declAx)) {
                this.ontology = this.getOWLModelManager().getActiveOntology();
            }
            entity.accept((OWLEntityVisitor)this.activeEntityVisitor);
            if (OWLUtilities.isDeprecated(this.getOWLModelManager(), (OWLObject)entity)) {
                this.deprecatedLabel.setIcon(this.deprecatedIcon);
                this.deprecatedLabel.setPreferredSize(new Dimension(this.deprecatedIcon.getIconWidth(), this.plainFontHeight));
            } else {
                this.deprecatedLabel.setIcon(null);
            }
        }
        this.prepareTextPane(this.getRendering(value), isSelected);
        if (isSelected) {
            this.renderingComponent.setBackground(SELECTION_BACKGROUND);
            this.textPane.setForeground(SELECTION_FOREGROUND);
        } else {
            this.renderingComponent.setBackground(this.componentBeingRendered.getBackground());
            this.textPane.setForeground(this.componentBeingRendered.getForeground());
        }
        Icon icon = this.getIcon(value);
        this.iconLabel.setIcon(icon);
        if (icon != null) {
            this.iconLabel.setPreferredSize(new Dimension(icon.getIconWidth(), this.plainFontHeight));
        }
        this.renderingComponent.revalidate();
        return this.renderingComponent;
    }

    protected String getRendering(Object object) {
        if (object instanceof OWLObject) {
            String rendering = this.getOWLModelManager().getRendering((OWLObject)object);
            for (OWLObject eqObj : this.equivalentObjects) {
                rendering = rendering + " \u2261 " + this.getOWLModelManager().getRendering(eqObj);
            }
            return rendering;
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    protected Icon getIcon(Object object) {
        if (!this.renderIcon) {
            return null;
        }
        if (this.iconObject != null) {
            return this.owlEditorKit.getWorkspace().getOWLIconProvider().getIcon(this.iconObject);
        }
        if (object instanceof OWLObject) {
            return this.owlEditorKit.getWorkspace().getOWLIconProvider().getIcon((OWLObject)object);
        }
        return null;
    }

    private OWLModelManager getOWLModelManager() {
        return this.owlEditorKit.getModelManager();
    }

    protected Color getColor(OWLEntity entity, Color defaultColor) {
        for (OWLEntityColorProvider prov : this.entityColorProviders) {
            Color c = prov.getColor(entity);
            if (c == null) continue;
            return c;
        }
        return defaultColor;
    }

    protected boolean activeOntologyContainsAxioms(OWLEntity owlEntity) {
        return !this.getOWLModelManager().getActiveOntology().getReferencingAxioms(owlEntity).isEmpty();
    }

    private void prepareStyles() {
        StyledDocument doc = this.textPane.getStyledDocument();
        Map<String, Color> keyWordColorMap = this.owlEditorKit.getWorkspace().getKeyWordColorMap();
        for (String keyWord : keyWordColorMap.keySet()) {
            Style s = doc.addStyle(keyWord, null);
            Color color = keyWordColorMap.get(keyWord);
            StyleConstants.setForeground(s, color);
            StyleConstants.setBold(s, true);
        }
        this.plainStyle = doc.addStyle("PLAIN_STYLE", null);
        StyleConstants.setItalic(this.plainStyle, false);
        StyleConstants.setSpaceAbove(this.plainStyle, 0.0f);
        this.boldStyle = doc.addStyle("BOLD_STYLE", null);
        StyleConstants.setBold(this.boldStyle, true);
        this.nonBoldStyle = doc.addStyle("NON_BOLD_STYLE", null);
        StyleConstants.setBold(this.nonBoldStyle, false);
        this.selectionForeground = doc.addStyle("SEL_FG_STYPE", null);
        if (this.selectionForeground != null && SELECTION_FOREGROUND != null) {
            StyleConstants.setForeground(this.selectionForeground, SELECTION_FOREGROUND);
        }
        this.foreground = doc.addStyle("FG_STYLE", null);
        if (this.foreground != null && FOREGROUND != null) {
            StyleConstants.setForeground(this.foreground, FOREGROUND);
        }
        this.linkStyle = doc.addStyle("LINK_STYLE", null);
        StyleConstants.setForeground(this.linkStyle, Color.BLUE);
        StyleConstants.setUnderline(this.linkStyle, true);
        this.inconsistentClassStyle = doc.addStyle("INCONSISTENT_CLASS_STYLE", null);
        StyleConstants.setForeground(this.inconsistentClassStyle, Color.RED);
        this.focusedEntityStyle = doc.addStyle("FOCUSED_ENTITY_STYLE", null);
        StyleConstants.setForeground(this.focusedEntityStyle, Color.BLACK);
        StyleConstants.setBackground(this.focusedEntityStyle, new Color(220, 220, 250));
        this.ontologyURIStyle = doc.addStyle("ONTOLOGY_URI_STYLE", null);
        StyleConstants.setForeground(this.ontologyURIStyle, Color.GRAY);
        this.commentedOutStyle = doc.addStyle("COMMENTED_OUT_STYLE", null);
        StyleConstants.setForeground(this.commentedOutStyle, Color.GRAY);
        StyleConstants.setItalic(this.commentedOutStyle, true);
        this.strikeOutStyle = doc.addStyle("STRIKE_OUT", null);
        StyleConstants.setStrikeThrough(this.strikeOutStyle, true);
        StyleConstants.setBold(this.strikeOutStyle, false);
        this.fontSizeStyle = doc.addStyle("FONT_SIZE", null);
        StyleConstants.setFontSize(this.fontSizeStyle, 40);
    }

    private void prepareTextPane(Object value, boolean selected) {
        this.textPane.setBorder(null);
        String theVal = value.toString();
        if (!this.wrap) {
            theVal = theVal.replace('\n', ' ');
            theVal = theVal.replaceAll(" [ ]+", " ");
        }
        this.textPane.setText(theVal);
        if (this.commentedOut) {
            this.textPane.setText("// " + this.textPane.getText());
        }
        StyledDocument doc = this.textPane.getStyledDocument();
        this.resetStyles(doc);
        if (selected) {
            doc.setParagraphAttributes(0, doc.getLength(), this.selectionForeground, false);
        } else {
            doc.setParagraphAttributes(0, doc.getLength(), this.foreground, false);
        }
        if (this.commentedOut) {
            doc.setParagraphAttributes(0, doc.getLength(), this.commentedOutStyle, false);
            return;
        }
        if (this.inferred) {
            // empty if block
        }
        if (this.strikeThrough) {
            doc.setParagraphAttributes(0, doc.getLength(), this.strikeOutStyle, false);
        }
        if (this.ontology != null) {
            if (OWLRendererPreferences.getInstance().isHighlightActiveOntologyStatements() && this.getOWLModelManager().getActiveOntology().equals(this.ontology)) {
                doc.setParagraphAttributes(0, doc.getLength(), this.boldStyle, false);
            } else {
                doc.setParagraphAttributes(0, doc.getLength(), this.nonBoldStyle, false);
            }
        } else {
            this.textPane.setFont(this.plainFont);
        }
        if (this.ontology != null) {
            if (this.getOWLModelManager().isMutable(this.ontology)) {
                this.textPane.setEnabled(!this.forceReadOnlyRendering);
            } else {
                this.textPane.setEnabled(false);
            }
        } else if (value instanceof OWLEntity && this.activeOntologyContainsAxioms((OWLEntity)value)) {
            this.textPane.setFont(this.boldFont);
        }
        this.highlightText(doc);
    }

    protected void highlightText(StyledDocument doc) {
        StringTokenizer tokenizer = new StringTokenizer(this.textPane.getText(), " []{}(),\n\t'", true);
        this.linkRendered = false;
        this.annotURIRendered = false;
        int tokenStartIndex = 0;
        while (tokenizer.hasMoreTokens()) {
            String curToken = tokenizer.nextToken();
            if (curToken.equals("'")) {
                while (tokenizer.hasMoreTokens()) {
                    String s = tokenizer.nextToken();
                    curToken = curToken + s;
                    if (!s.equals("'")) continue;
                    break;
                }
            }
            this.renderToken(curToken, tokenStartIndex, doc);
            tokenStartIndex += curToken.length();
        }
        if (this.renderLinks && !this.linkRendered) {
            this.linkedObjectComponent.setLinkedObject(null);
        }
    }

    protected void renderToken(String curToken, final int tokenStartIndex, final StyledDocument doc) {
        boolean enclosedByBracket = false;
        if (this.parenthesisRendered) {
            this.parenthesisRendered = false;
            enclosedByBracket = true;
        }
        OWLRendererPreferences prefs = OWLRendererPreferences.getInstance();
        final int tokenLength = curToken.length();
        Color c = this.owlEditorKit.getWorkspace().getKeyWordColorMap().get(curToken);
        if (c != null && prefs.isHighlightKeyWords() && this.highlightKeywords) {
            Style s = doc.getStyle(curToken);
            doc.setCharacterAttributes(tokenStartIndex, tokenLength, s, true);
        } else {
            final OWLEntity curEntity = this.getOWLModelManager().getOWLEntityFinder().getOWLEntity(curToken);
            if (curEntity != null) {
                if (this.focusedEntity != null) {
                    if (curEntity.equals(this.focusedEntity)) {
                        doc.setCharacterAttributes(tokenStartIndex, tokenLength, this.focusedEntityStyle, true);
                    }
                } else if (this.highlightUnsatisfiableClasses && curEntity instanceof OWLClass) {
                    this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_CLASS_UNSATISFIABILITY, new Runnable(){

                        public void run() {
                            OWLReasoner reasoner = OWLCellRenderer.this.getOWLModelManager().getReasoner();
                            boolean consistent = reasoner.isConsistent();
                            if (!consistent || !OWLCellRenderer.this.getOWLModelManager().getReasoner().isSatisfiable((OWLClassExpression)((OWLClass)curEntity))) {
                                doc.setCharacterAttributes(tokenStartIndex, tokenLength, OWLCellRenderer.this.inconsistentClassStyle, true);
                            }
                        }
                    });
                } else if (this.highlightUnsatisfiableProperties && curEntity instanceof OWLObjectProperty) {
                    this.highlightPropertyIfUnsatisfiable(curEntity, doc, tokenStartIndex, tokenLength);
                }
                this.strikeoutEntityIfCrossedOut(curEntity, doc, tokenStartIndex, tokenLength);
                if (this.renderLinks) {
                    this.renderHyperlink(curEntity, tokenStartIndex, tokenLength, doc);
                }
            } else if (this.highlightUnsatisfiableClasses && this.unsatisfiableNames.contains(curToken)) {
                doc.setCharacterAttributes(tokenStartIndex, tokenLength, this.inconsistentClassStyle, true);
            } else if (this.isOntologyURI(curToken)) {
                this.fadeOntologyURI(doc, tokenStartIndex, tokenLength, enclosedByBracket);
            } else if (curToken.equals("(")) {
                this.parenthesisRendered = true;
            }
        }
    }

    private void renderHyperlink(OWLEntity curEntity, int tokenStartIndex, int tokenLength, StyledDocument doc) {
        try {
            Rectangle startRect = this.textPane.modelToView(tokenStartIndex);
            Rectangle endRect = this.textPane.modelToView(tokenStartIndex + tokenLength);
            if (startRect != null && endRect != null) {
                Point mouseCellLocation;
                int width = endRect.x - startRect.x;
                int heght = startRect.height;
                Rectangle tokenRect = new Rectangle(startRect.x, startRect.y, width, heght);
                tokenRect.grow(0, -2);
                if (this.linkedObjectComponent.getMouseCellLocation() != null && (mouseCellLocation = this.linkedObjectComponent.getMouseCellLocation()) != null && tokenRect.contains(mouseCellLocation = SwingUtilities.convertPoint(this.renderingComponent, mouseCellLocation, this.textPane))) {
                    doc.setCharacterAttributes(tokenStartIndex, tokenLength, this.linkStyle, false);
                    this.linkedObjectComponent.setLinkedObject((OWLObject)curEntity);
                    this.linkRendered = true;
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private boolean isOntologyURI(String token) {
        try {
            URI uri = new URI(token);
            if (uri.isAbsolute()) {
                IRI iri = IRI.create((URI)uri);
                OWLOntology ont = this.getOWLModelManager().getOWLOntologyManager().getOntology(iri);
                if (this.getOWLModelManager().getActiveOntologies().contains(ont)) {
                    return true;
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return false;
    }

    private void fadeOntologyURI(StyledDocument doc, int tokenStartIndex, int tokenLength, boolean enclosedByBracket) {
        int start = tokenStartIndex;
        int length = tokenLength;
        if (enclosedByBracket) {
            --start;
            length += 2;
        }
        doc.setCharacterAttributes(start, length, this.ontologyURIStyle, true);
    }

    private void strikeoutEntityIfCrossedOut(OWLEntity entity, StyledDocument doc, int tokenStartIndex, int tokenLength) {
        if (this.crossedOutEntities.contains(entity)) {
            doc.setCharacterAttributes(tokenStartIndex, tokenLength, this.strikeOutStyle, false);
        }
    }

    private void highlightPropertyIfUnsatisfiable(final OWLEntity entity, final StyledDocument doc, final int tokenStartIndex, final int tokenLength) {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_OBJECT_PROPERTY_UNSATISFIABILITY, new Runnable(){

            public void run() {
                OWLObjectProperty prop = (OWLObjectProperty)entity;
                OWLReasoner reasoner = OWLCellRenderer.this.getOWLModelManager().getReasoner();
                boolean consistent = reasoner.isConsistent();
                if (!consistent || reasoner.getBottomObjectPropertyNode().contains((OWLObject)prop)) {
                    doc.setCharacterAttributes(tokenStartIndex, tokenLength, OWLCellRenderer.this.inconsistentClassStyle, true);
                }
            }
        });
    }

    private void resetStyles(StyledDocument doc) {
        doc.setParagraphAttributes(0, doc.getLength(), this.plainStyle, true);
        StyleConstants.setFontSize(this.fontSizeStyle, this.getFontSize());
        Font f = OWLRendererPreferences.getInstance().getFont();
        StyleConstants.setFontFamily(this.fontSizeStyle, f.getFamily());
        doc.setParagraphAttributes(0, doc.getLength(), this.fontSizeStyle, false);
        this.setupFont();
    }

    private class OWLCellRendererLayoutManager
    implements LayoutManager2 {
        private OWLCellRendererLayoutManager() {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            int width;
            int textHeight;
            JList list;
            if (OWLCellRenderer.this.componentBeingRendered instanceof JList && (list = (JList)OWLCellRenderer.this.componentBeingRendered).getFixedCellHeight() != -1) {
                return new Dimension(list.getWidth(), list.getHeight());
            }
            int iconWidth = ((OWLCellRenderer)OWLCellRenderer.this).iconLabel.getPreferredSize().width;
            int iconHeight = ((OWLCellRenderer)OWLCellRenderer.this).iconLabel.getPreferredSize().height;
            int deprecatedWidth = ((OWLCellRenderer)OWLCellRenderer.this).deprecatedLabel.getPreferredSize().width;
            int deprecatedHeight = ((OWLCellRenderer)OWLCellRenderer.this).deprecatedLabel.getPreferredSize().height;
            Insets insets = parent.getInsets();
            Insets rcInsets = OWLCellRenderer.this.renderingComponent.getInsets();
            if (OWLCellRenderer.this.preferredWidth != -1) {
                int textWidth = OWLCellRenderer.this.preferredWidth - iconWidth - deprecatedWidth - rcInsets.left - rcInsets.right;
                View v = OWLCellRenderer.this.textPane.getUI().getRootView(OWLCellRenderer.this.textPane);
                v.setSize(textWidth, 2.1474836E9f);
                textHeight = (int)v.getMinimumSpan(1);
                width = OWLCellRenderer.this.preferredWidth;
            } else {
                int textWidth = ((OWLCellRenderer)OWLCellRenderer.this).textPane.getPreferredSize().width;
                textHeight = ((OWLCellRenderer)OWLCellRenderer.this).textPane.getPreferredSize().height;
                width = textWidth + iconWidth + deprecatedWidth;
            }
            int height = textHeight < iconHeight || textHeight < deprecatedHeight ? (iconHeight > deprecatedHeight ? iconHeight : deprecatedHeight) : textHeight;
            int minHeight = OWLCellRenderer.this.minTextHeight;
            if (height < minHeight) {
                height = minHeight;
            }
            int totalWidth = width + rcInsets.left + rcInsets.right;
            int totalHeight = height + rcInsets.top + rcInsets.bottom;
            return new Dimension(totalWidth, totalHeight);
        }

        public void layoutContainer(Container parent) {
            int textHeight;
            int textWidth;
            Insets rcInsets = OWLCellRenderer.this.renderingComponent.getInsets();
            int iconWidth = ((OWLCellRenderer)OWLCellRenderer.this).iconLabel.getPreferredSize().width;
            int iconHeight = ((OWLCellRenderer)OWLCellRenderer.this).iconLabel.getPreferredSize().height;
            int deprecatedWidth = ((OWLCellRenderer)OWLCellRenderer.this).deprecatedLabel.getPreferredSize().width;
            int deprecatedHeight = ((OWLCellRenderer)OWLCellRenderer.this).deprecatedLabel.getPreferredSize().height;
            if (OWLCellRenderer.this.preferredWidth != -1) {
                textWidth = OWLCellRenderer.this.preferredWidth - iconWidth - rcInsets.left - rcInsets.right;
                View v = OWLCellRenderer.this.textPane.getUI().getRootView(OWLCellRenderer.this.textPane);
                v.setSize(textWidth, 2.1474836E9f);
                textHeight = (int)v.getMinimumSpan(1);
            } else {
                textWidth = ((OWLCellRenderer)OWLCellRenderer.this).textPane.getPreferredSize().width;
                textHeight = ((OWLCellRenderer)OWLCellRenderer.this).textPane.getPreferredSize().height;
                if (textHeight < OWLCellRenderer.this.minTextHeight) {
                    textHeight = OWLCellRenderer.this.minTextHeight;
                }
            }
            int leftOffset = rcInsets.left;
            int topOffset = rcInsets.top;
            OWLCellRenderer.this.iconLabel.setBounds(leftOffset, topOffset, iconWidth, iconHeight);
            OWLCellRenderer.this.textPane.setBounds(leftOffset + iconWidth, topOffset, textWidth, textHeight);
            OWLCellRenderer.this.deprecatedLabel.setBounds(leftOffset + iconWidth + textWidth, topOffset, deprecatedWidth, deprecatedHeight);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }
    }

    private class ActiveEntityVisitor
    implements OWLEntityVisitor {
        private ActiveEntityVisitor() {
        }

        public void visit(OWLClass cls) {
            if (!OWLCellRenderer.this.getOWLModelManager().getActiveOntology().getAxioms(cls).isEmpty()) {
                OWLCellRenderer.this.ontology = OWLCellRenderer.this.getOWLModelManager().getActiveOntology();
            }
        }

        public void visit(OWLDatatype dataType) {
            if (!OWLCellRenderer.this.getOWLModelManager().getActiveOntology().getAxioms(dataType).isEmpty()) {
                OWLCellRenderer.this.ontology = OWLCellRenderer.this.getOWLModelManager().getActiveOntology();
            }
        }

        public void visit(OWLNamedIndividual individual) {
            if (!OWLCellRenderer.this.getOWLModelManager().getActiveOntology().getAxioms((OWLIndividual)individual).isEmpty()) {
                OWLCellRenderer.this.ontology = OWLCellRenderer.this.getOWLModelManager().getActiveOntology();
            }
        }

        public void visit(OWLDataProperty property) {
            if (!OWLCellRenderer.this.getOWLModelManager().getActiveOntology().getAxioms(property).isEmpty()) {
                OWLCellRenderer.this.ontology = OWLCellRenderer.this.getOWLModelManager().getActiveOntology();
            }
        }

        public void visit(OWLObjectProperty property) {
            if (!OWLCellRenderer.this.getOWLModelManager().getActiveOntology().getAxioms((OWLObjectPropertyExpression)property).isEmpty()) {
                OWLCellRenderer.this.ontology = OWLCellRenderer.this.getOWLModelManager().getActiveOntology();
            }
        }

        public void visit(OWLAnnotationProperty property) {
            if (!OWLCellRenderer.this.getOWLModelManager().getActiveOntology().getAxioms(property).isEmpty()) {
                OWLCellRenderer.this.ontology = OWLCellRenderer.this.getOWLModelManager().getActiveOntology();
            }
        }
    }
}

