/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.AbstractOWLEntityRenderer;
import org.protege.editor.owl.ui.renderer.AnnotationRendererPanel;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.RenderingEscapeUtils;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEntityAnnotationValueRenderer
extends AbstractOWLEntityRenderer {
    private AnnotationValueShortFormProvider provider;

    @Override
    public void initialise() {
        OWLDataFactory df = this.getOWLModelManager().getOWLDataFactory();
        ArrayList<OWLAnnotationProperty> properties = new ArrayList<OWLAnnotationProperty>();
        HashMap<OWLAnnotationProperty, List<String>> propLangMap = new HashMap<OWLAnnotationProperty, List<String>>();
        Map<IRI, List<String>> iriLangMap = OWLRendererPreferences.getInstance().getAnnotationLangMap();
        for (IRI iri : OWLRendererPreferences.getInstance().getAnnotationIRIs()) {
            OWLAnnotationProperty ap = df.getOWLAnnotationProperty(iri);
            properties.add(ap);
            propLangMap.put(ap, iriLangMap.get(iri));
        }
        this.provider = new AnnotationValueShortFormProvider(properties, propLangMap, (OWLOntologySetProvider)this.getOWLModelManager().getOWLOntologyManager());
    }

    @Override
    public String render(IRI iri) {
        OWLClass entity = this.getOWLModelManager().getOWLDataFactory().getOWLClass(iri);
        String shortForm = this.provider.getShortForm((OWLEntity)entity);
        return this.escape(shortForm);
    }

    @Override
    protected void processChanges(List<? extends OWLOntologyChange> changes) {
        List properties = this.provider.getAnnotationProperties();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            OWLAnnotationSubject subject;
            OWLAnnotationAssertionAxiom ax;
            if (!oWLOntologyChange.isAxiomChange() || !oWLOntologyChange.getAxiom().getAxiomType().equals(AxiomType.ANNOTATION_ASSERTION) || !properties.contains((ax = (OWLAnnotationAssertionAxiom)oWLOntologyChange.getAxiom()).getProperty()) || !((subject = ax.getSubject()) instanceof IRI)) continue;
            IRI iri = (IRI)subject;
            OWLDataFactory factory = this.getOWLModelManager().getOWLDataFactory();
            this.fireRenderingChanged((OWLEntity)factory.getOWLClass(iri));
            this.fireRenderingChanged((OWLEntity)factory.getOWLObjectProperty(iri));
            this.fireRenderingChanged((OWLEntity)factory.getOWLDataProperty(iri));
            this.fireRenderingChanged((OWLEntity)factory.getOWLAnnotationProperty(iri));
            this.fireRenderingChanged((OWLEntity)factory.getOWLNamedIndividual(iri));
        }
    }

    @Override
    protected void disposeRenderer() {
    }

    protected String escape(String rendering) {
        return RenderingEscapeUtils.getEscapedRendering(rendering);
    }

    protected AnnotationValueShortFormProvider getProvider() {
        return this.provider;
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean configure(OWLEditorKit eKit) {
        return AnnotationRendererPanel.showDialog(eKit);
    }
}

