/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.prefix.PrefixUtilities;
import org.protege.editor.owl.ui.renderer.AbstractOWLEntityRenderer;
import org.protege.editor.owl.ui.renderer.prefix.PrefixBasedRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.PrefixManager;

public class OWLEntityQNameRenderer
extends AbstractOWLEntityRenderer
implements PrefixBasedRenderer {
    private PrefixManager prefixManager;

    public void initialise() {
        this.prefixManager = PrefixUtilities.getPrefixOWLOntologyFormat(this.getOWLModelManager());
    }

    public void ontologiesChanged() {
        this.initialise();
    }

    public String render(IRI iri) {
        try {
            String s = this.prefixManager.getPrefixIRI(iri);
            if (s != null) {
                if (s.startsWith(":")) {
                    s = s.substring(1);
                }
                return s;
            }
            return iri.toQuotedString();
        }
        catch (Exception e) {
            return "<Error! " + e.getMessage() + ">";
        }
    }

    public boolean isConfigurable() {
        return false;
    }

    public boolean configure(OWLEditorKit eKit) {
        throw new IllegalStateException("This renderer is not configurable");
    }

    protected void disposeRenderer() {
    }
}

