/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.selector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.selector.OWLObjectSelector;
import org.semanticweb.owlapi.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectorPanel<O extends OWLObject>
extends JPanel
implements OWLObjectSelector<O>,
VerifiedInputEditor {
    private static final long serialVersionUID = -3436408401382241385L;
    private OWLEditorKit editorKit;
    private View view;
    private boolean editable;
    private List<InputVerificationStatusChangedListener> validateListeners = new ArrayList<InputVerificationStatusChangedListener>();
    public boolean isValid = false;
    private boolean registeredListener = false;

    public AbstractSelectorPanel(OWLEditorKit editorKit) {
        this(editorKit, true);
    }

    public AbstractSelectorPanel(OWLEditorKit editorKit, boolean editable) {
        this(editorKit, editable, true);
    }

    public AbstractSelectorPanel(OWLEditorKit editorKit, boolean editable, boolean autoCreateUI) {
        this.editorKit = editorKit;
        this.editable = editable;
        if (autoCreateUI) {
            this.createUI();
        }
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.editorKit;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 500);
    }

    public OWLModelManager getOWLModelManager() {
        return this.editorKit.getModelManager();
    }

    protected void createUI() {
        this.setLayout(new BorderLayout());
        ViewComponentPlugin plugin = this.getViewComponentPlugin();
        this.view = new View(plugin, (Workspace)this.editorKit.getWorkspace());
        this.view.setPinned(true);
        this.view.setSyncronizing(false);
        this.view.createUI();
        this.view.setShowViewBanner(false);
        this.add((Component)this.view);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.view.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent event) {
                if (!AbstractSelectorPanel.this.registeredListener) {
                    AbstractSelectorPanel.this.addSelectionListener(new ChangeListener(){

                        public void stateChanged(ChangeEvent event) {
                            boolean valid = AbstractSelectorPanel.this.getSelectedObjects() != null && !AbstractSelectorPanel.this.getSelectedObjects().isEmpty();
                            for (InputVerificationStatusChangedListener l : AbstractSelectorPanel.this.validateListeners) {
                                l.verifiedStatusChanged(valid);
                            }
                            AbstractSelectorPanel.this.isValid = valid;
                        }
                    });
                    AbstractSelectorPanel.this.registeredListener = true;
                }
            }
        });
    }

    public void clearSelection() {
        this.setSelection((OWLObject)null);
    }

    public abstract void setSelection(O var1);

    public abstract void setSelection(Set<O> var1);

    @Override
    public abstract O getSelectedObject();

    @Override
    public abstract Set<O> getSelectedObjects();

    @Override
    public boolean requestFocusInWindow() {
        return this.view.requestFocusInWindow();
    }

    protected final boolean isEditable() {
        return this.editable;
    }

    protected abstract ViewComponentPlugin getViewComponentPlugin();

    public abstract void addSelectionListener(ChangeListener var1);

    public abstract void removeSelectionListener(ChangeListener var1);

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.validateListeners.add(listener);
        listener.verifiedStatusChanged(this.isValid);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.validateListeners.remove(listener);
    }

    public void dispose() {
        if (this.view != null) {
            this.view.dispose();
        }
    }
}

