/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.selector;

import java.awt.Color;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.view.ViewComponentPluginAdapter;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.ui.renderer.OWLSystemColors;
import org.protege.editor.owl.ui.selector.AbstractHierarchySelectorPanel;
import org.protege.editor.owl.ui.view.AbstractOWLEntityHierarchyViewComponent;
import org.protege.editor.owl.ui.view.cls.ToldOWLClassHierarchyViewComponent;
import org.semanticweb.owlapi.model.OWLClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLClassSelectorPanel
extends AbstractHierarchySelectorPanel<OWLClass> {
    private AbstractOWLEntityHierarchyViewComponent<OWLClass> vc;

    public OWLClassSelectorPanel(OWLEditorKit editorKit) {
        this(editorKit, true);
    }

    public OWLClassSelectorPanel(OWLEditorKit editorKit, boolean editable) {
        this(editorKit, editable, editorKit.getModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider());
    }

    public OWLClassSelectorPanel(OWLEditorKit editorKit, boolean editable, OWLObjectHierarchyProvider<OWLClass> hp) {
        super(editorKit, editable, hp);
    }

    @Override
    protected ViewComponentPlugin getViewComponentPlugin() {
        return new ViewComponentPluginAdapter(){

            public String getLabel() {
                return "Asserted Class Hierarchy";
            }

            public Workspace getWorkspace() {
                return OWLClassSelectorPanel.this.getOWLEditorKit().getWorkspace();
            }

            public ViewComponent newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
                OWLClassSelectorPanel.this.vc = new ToldOWLClassHierarchyViewComponent(){

                    @Override
                    public void performExtraInitialisation() throws Exception {
                        if (OWLClassSelectorPanel.this.isEditable()) {
                            super.performExtraInitialisation();
                        }
                    }

                    protected OWLObjectHierarchyProvider<OWLClass> getOWLClassHierarchyProvider() {
                        return this.getHierarchyProvider();
                    }
                };
                OWLClassSelectorPanel.this.vc.setup((ViewComponentPlugin)this);
                return OWLClassSelectorPanel.this.vc;
            }

            public Color getBackgroundColor() {
                return OWLSystemColors.getOWLClassColor();
            }
        };
    }

    @Override
    public void setSelection(OWLClass cls) {
        this.vc.setSelectedEntity(cls);
    }

    @Override
    public void setSelection(Set<OWLClass> clses) {
        this.vc.setSelectedEntities(clses);
    }

    @Override
    public OWLClass getSelectedObject() {
        return this.vc.getSelectedEntity();
    }

    @Override
    public Set<OWLClass> getSelectedObjects() {
        return this.vc.getSelectedEntities();
    }

    @Override
    public void dispose() {
        this.vc.dispose();
    }

    @Override
    public void addSelectionListener(ChangeListener listener) {
        this.vc.addChangeListener(listener);
    }

    @Override
    public void removeSelectionListener(ChangeListener listener) {
        this.vc.removeChangeListener(listener);
    }
}

