/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.selector;

import java.awt.Color;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.view.ViewComponentPluginAdapter;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.ui.renderer.OWLSystemColors;
import org.protege.editor.owl.ui.selector.AbstractHierarchySelectorPanel;
import org.protege.editor.owl.ui.view.AbstractOWLPropertyHierarchyViewComponent;
import org.protege.editor.owl.ui.view.dataproperty.OWLDataPropertyHierarchyViewComponent;
import org.semanticweb.owlapi.model.OWLDataProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLDataPropertySelectorPanel
extends AbstractHierarchySelectorPanel<OWLDataProperty> {
    private AbstractOWLPropertyHierarchyViewComponent<OWLDataProperty> vc;

    public OWLDataPropertySelectorPanel(OWLEditorKit eKit) {
        this(eKit, true);
    }

    public OWLDataPropertySelectorPanel(OWLEditorKit eKit, boolean editable) {
        this(eKit, editable, eKit.getModelManager().getOWLHierarchyManager().getOWLDataPropertyHierarchyProvider());
    }

    public OWLDataPropertySelectorPanel(OWLEditorKit eKit, boolean editable, OWLObjectHierarchyProvider<OWLDataProperty> hp) {
        super(eKit, editable, hp);
    }

    @Override
    protected ViewComponentPlugin getViewComponentPlugin() {
        return new ViewComponentPluginAdapter(){

            public String getLabel() {
                return "Data properties";
            }

            public Workspace getWorkspace() {
                return OWLDataPropertySelectorPanel.this.getOWLEditorKit().getWorkspace();
            }

            public ViewComponent newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
                OWLDataPropertySelectorPanel.this.vc = new OWLDataPropertyHierarchyViewComponent(){

                    @Override
                    protected void performExtraInitialisation() throws Exception {
                        if (OWLDataPropertySelectorPanel.this.isEditable()) {
                            super.performExtraInitialisation();
                        }
                    }

                    @Override
                    protected OWLObjectHierarchyProvider<OWLDataProperty> getHierarchyProvider() {
                        return OWLDataPropertySelectorPanel.this.getHierarchyProvider();
                    }
                };
                OWLDataPropertySelectorPanel.this.vc.setup((ViewComponentPlugin)this);
                return OWLDataPropertySelectorPanel.this.vc;
            }

            public Color getBackgroundColor() {
                return OWLSystemColors.getOWLDataPropertyColor();
            }
        };
    }

    @Override
    public void setSelection(OWLDataProperty property) {
        this.vc.setSelectedEntity(property);
    }

    @Override
    public void setSelection(Set<OWLDataProperty> properties) {
        this.vc.setSelectedEntities(properties);
    }

    @Override
    public OWLDataProperty getSelectedObject() {
        return (OWLDataProperty)this.vc.getSelectedEntity();
    }

    @Override
    public Set<OWLDataProperty> getSelectedObjects() {
        return this.vc.getSelectedEntities();
    }

    @Override
    public void addSelectionListener(ChangeListener listener) {
        this.vc.addChangeListener(listener);
    }

    @Override
    public void removeSelectionListener(ChangeListener listener) {
        this.vc.removeChangeListener(listener);
    }

    @Override
    public void dispose() {
        this.vc.dispose();
    }
}

