/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.selector;

import java.awt.Color;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.view.ViewComponentPluginAdapter;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLSystemColors;
import org.protege.editor.owl.ui.selector.AbstractSelectorPanel;
import org.protege.editor.owl.ui.view.individual.OWLIndividualListViewComponent;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLIndividualSelectorPanel
extends AbstractSelectorPanel<OWLNamedIndividual> {
    private OWLIndividualListViewComponent vc;
    private Set<OWLOntology> ontologies;

    public OWLIndividualSelectorPanel(OWLEditorKit eKit) {
        this(eKit, true);
    }

    public OWLIndividualSelectorPanel(OWLEditorKit eKit, boolean editable) {
        this(eKit, editable, eKit.getModelManager().getActiveOntologies());
    }

    public OWLIndividualSelectorPanel(OWLEditorKit eKit, boolean editable, Set<OWLOntology> ontologies) {
        this(eKit, editable, ontologies, 0);
    }

    public OWLIndividualSelectorPanel(OWLEditorKit eKit, int selectionMode) {
        this(eKit, true, null, selectionMode);
    }

    public OWLIndividualSelectorPanel(OWLEditorKit eKit, boolean editable, Set<OWLOntology> ontologies, int selectionMode) {
        super(eKit, editable, false);
        this.ontologies = ontologies;
        this.createUI();
        this.vc.setSelectionMode(selectionMode);
    }

    @Override
    public void setSelection(OWLNamedIndividual ind) {
        if (this.vc.getView() != null) {
            this.vc.getView().setPinned(false);
        }
        this.vc.setSelectedIndividual((OWLIndividual)ind);
    }

    @Override
    public void setSelection(Set<OWLNamedIndividual> entities) {
        this.vc.setSelectedIndividuals(entities);
    }

    @Override
    public OWLNamedIndividual getSelectedObject() {
        return this.vc.getSelectedIndividual();
    }

    @Override
    public Set<OWLNamedIndividual> getSelectedObjects() {
        return this.vc.getSelectedIndividuals();
    }

    @Override
    public void dispose() {
        this.vc.dispose();
    }

    @Override
    protected ViewComponentPlugin getViewComponentPlugin() {
        return new ViewComponentPluginAdapter(){

            public String getLabel() {
                return "Individuals";
            }

            public Workspace getWorkspace() {
                return OWLIndividualSelectorPanel.this.getOWLEditorKit().getWorkspace();
            }

            public ViewComponent newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
                OWLIndividualSelectorPanel.this.vc = new OWLIndividualListViewComponent(){

                    @Override
                    protected void setupActions() {
                        if (OWLIndividualSelectorPanel.this.isEditable()) {
                            super.setupActions();
                        }
                    }

                    @Override
                    protected Set<OWLOntology> getOntologies() {
                        if (OWLIndividualSelectorPanel.this.ontologies != null) {
                            return OWLIndividualSelectorPanel.this.ontologies;
                        }
                        return super.getOntologies();
                    }
                };
                OWLIndividualSelectorPanel.this.vc.setup((ViewComponentPlugin)this);
                return OWLIndividualSelectorPanel.this.vc;
            }

            public Color getBackgroundColor() {
                return OWLSystemColors.getOWLIndividualColor();
            }
        };
    }

    public void setOntologies(Set<OWLOntology> ontologies) {
    }

    @Override
    public void addSelectionListener(ChangeListener listener) {
        this.vc.addChangeListener(listener);
    }

    @Override
    public void removeSelectionListener(ChangeListener listener) {
        this.vc.removeChangeListener(listener);
    }
}

