/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.selector;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.list.OWLObjectList;
import org.semanticweb.owlapi.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLOntologySelectorPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(OWLOntologySelectorPanel.class);
    private OWLEditorKit owlEditorKit;
    private OWLObjectList list;

    public OWLOntologySelectorPanel(OWLEditorKit owlEditorKit) {
        this(owlEditorKit, owlEditorKit.getModelManager().getOntologies());
    }

    public OWLOntologySelectorPanel(OWLEditorKit owlEditorKit, Set<OWLOntology> ontologies) {
        this.owlEditorKit = owlEditorKit;
        this.list = new OWLObjectList(owlEditorKit);
        OWLModelManager mngr = owlEditorKit.getModelManager();
        ArrayList<OWLOntology> orderedOntologies = new ArrayList<OWLOntology>(ontologies);
        Collections.sort(orderedOntologies, mngr.getOWLObjectComparator());
        this.list.setListData(orderedOntologies.toArray());
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.list));
    }

    public void setMultipleSelectionEnabled(boolean multiselect) {
        this.list.setSelectionMode(multiselect ? 2 : 0);
    }

    public void setSelection(Set<OWLOntology> ontologies) {
        this.list.setSelectedValues(ontologies, true);
    }

    public void setSelection(OWLOntology ontology) {
        this.list.setSelectedValues(Collections.singleton(ontology), true);
    }

    public Set<OWLOntology> getSelectedOntologies() {
        HashSet<OWLOntology> ontologies = new HashSet<OWLOntology>();
        for (Object o : this.list.getSelectedValues()) {
            ontologies.add((OWLOntology)o);
        }
        return ontologies;
    }

    public OWLOntology getSelectedOntology() {
        Object ont = this.list.getSelectedValue();
        return ont == null ? null : (OWLOntology)ont;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 400);
    }
}

