/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.table;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.LinkedObjectComponent;
import org.protege.editor.owl.ui.renderer.LinkedObjectComponentMediator;
import org.protege.editor.owl.ui.table.BasicOWLTable;
import org.semanticweb.owlapi.model.OWLObject;

public class BasicLinkedOWLObjectTable
extends BasicOWLTable
implements LinkedObjectComponent {
    private OWLEditorKit editorKit;
    private OWLObject linkedObject;
    private Cursor defaultCursor;

    public BasicLinkedOWLObjectTable(TableModel model, OWLEditorKit owlEditorKit) {
        super(model);
        this.editorKit = owlEditorKit;
        this.defaultCursor = this.getCursor();
        LinkedObjectComponentMediator mediator = new LinkedObjectComponentMediator(owlEditorKit, this);
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.editorKit;
    }

    public Point getMouseCellLocation() {
        Point mouseLoc = this.getMousePosition();
        if (mouseLoc == null) {
            return null;
        }
        int row = this.rowAtPoint(mouseLoc);
        int col = this.columnAtPoint(mouseLoc);
        Rectangle cellRect = this.getCellRect(row, col, true);
        return new Point(mouseLoc.x - cellRect.x, mouseLoc.y - cellRect.y);
    }

    public Rectangle getMouseCellRect() {
        Point mousePos = this.getMousePosition();
        if (mousePos != null) {
            return this.getCellRect(this.rowAtPoint(mousePos), this.columnAtPoint(mousePos), true);
        }
        return null;
    }

    public Object getCellObject() {
        Point mouseLoc = this.getMousePosition();
        if (mouseLoc == null) {
            return null;
        }
        int row = this.rowAtPoint(mouseLoc);
        int col = this.columnAtPoint(mouseLoc);
        if (row > -1 && col > -1) {
            return this.getModel().getValueAt(row, col);
        }
        return null;
    }

    public void setLinkedObject(OWLObject object) {
        this.linkedObject = object;
        if (this.linkedObject != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(this.defaultCursor);
        }
    }

    public OWLObject getLinkedObject() {
        return this.linkedObject;
    }

    public JComponent getComponent() {
        return this;
    }
}

