/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.transfer;

import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.transfer.OWLObjectDragSource;
import org.protege.editor.owl.ui.transfer.TransferableOWLObject;
import org.semanticweb.owlapi.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLObjectDragGestureListener
implements DragGestureListener {
    private Cursor dragCursor = Cursor.getPredefinedCursor(13);
    private JComponent component;
    private OWLEditorKit owlEditorKit;

    protected OWLObjectDragGestureListener(OWLEditorKit owlEditorKit, JComponent component) {
        this.component = component;
        this.owlEditorKit = owlEditorKit;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        if (!this.canPerformDrag()) {
            return;
        }
        if (this.getSelectedObjects().isEmpty()) {
            return;
        }
        TransferableOWLObject transferable = new TransferableOWLObject(this.owlEditorKit.getModelManager(), this.getSelectedObjects());
        this.setupDragOriginator();
        dge.startDrag(this.dragCursor, transferable, new OWLDragSourceAdapter());
    }

    protected boolean canPerformDrag() {
        return true;
    }

    protected abstract List<OWLObject> getSelectedObjects();

    protected abstract JComponent getRendererComponent();

    protected abstract Dimension getRendererComponentSize();

    protected abstract Point getImageOffset();

    protected Image createImage() {
        JComponent component = this.getRendererComponent();
        component.setSize(this.getRendererComponentSize());
        BufferedImage img = new BufferedImage(component.getWidth(), component.getHeight(), 2);
        Graphics2D g2 = img.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(2, 0.6f));
        component.paint(g2);
        return img;
    }

    private void setupDragOriginator() {
        if (this.component instanceof OWLObjectDragSource) {
            ((OWLObjectDragSource)((Object)this.component)).setDragOriginater(true);
        }
    }

    private class OWLDragSourceAdapter
    extends DragSourceAdapter {
        private OWLDragSourceAdapter() {
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (OWLObjectDragGestureListener.this.component instanceof OWLObjectDragSource) {
                ((OWLObjectDragSource)((Object)OWLObjectDragGestureListener.this.component)).setDragOriginater(false);
            }
        }
    }
}

