/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.transfer;

import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import org.protege.editor.owl.ui.table.OWLObjectDropTargetListener;
import org.protege.editor.owl.ui.tree.OWLObjectTree;

public class OWLObjectTreeDropTargetListener
extends OWLObjectDropTargetListener {
    private OWLObjectTree tree;

    public OWLObjectTreeDropTargetListener(OWLObjectTree component) {
        super(component);
        this.tree = component;
    }

    protected boolean isDragAcceptable(DropTargetDragEvent event) {
        int row = this.tree.getRowForLocation(event.getLocation().x, event.getLocation().y);
        if (row == -1) {
            return false;
        }
        Rectangle r = this.tree.getRowBounds(row);
        if (!r.contains(event.getLocation())) {
            this.tree.setDropRow(-1);
            return false;
        }
        boolean isAcceptable = super.isDragAcceptable(event);
        if (isAcceptable) {
            this.tree.setDropRow(row);
        }
        return isAcceptable;
    }

    public void dragExit(DropTargetEvent dte) {
        super.dragExit(dte);
        this.tree.setDropRow(-1);
    }

    protected boolean isDropAcceptable(DropTargetDropEvent event) {
        return super.isDropAcceptable(event);
    }

    public void drop(DropTargetDropEvent dtde) {
        super.drop(dtde);
        this.tree.setDropRow(-1);
    }
}

