/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.tree;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.LinkedObjectComponent;
import org.protege.editor.owl.ui.renderer.LinkedObjectComponentMediator;
import org.protege.editor.owl.ui.tree.OWLObjectTreeCellRenderer;
import org.semanticweb.owlapi.model.OWLObject;

public class OWLLinkedObjectTree
extends JTree
implements LinkedObjectComponent {
    private OWLObject linkedObject;
    private boolean drawNodeSeperators = false;

    public OWLLinkedObjectTree(OWLEditorKit eKit) {
        this.setCellRenderer(new OWLObjectTreeCellRenderer(eKit));
        this.setRowHeight(-1);
        LinkedObjectComponentMediator mediator = new LinkedObjectComponentMediator(eKit, this);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.drawNodeSeperators) {
            Color oldColor = g.getColor();
            g.setColor(Color.LIGHT_GRAY);
            for (int i = 0; i < this.getRowCount(); ++i) {
                Rectangle rowBounds = this.getRowBounds(i);
                if (!g.getClipBounds().intersects(rowBounds) || this.getPathForRow(i).getPathCount() != 2) continue;
                g.drawLine(0, rowBounds.y, this.getWidth(), rowBounds.y);
            }
            g.setColor(oldColor);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public OWLObject getLinkedObject() {
        return this.linkedObject;
    }

    public Point getMouseCellLocation() {
        Point mousePos = this.getMousePosition();
        if (mousePos == null) {
            return null;
        }
        Rectangle r = this.getMouseCellRect();
        if (r == null) {
            return null;
        }
        return new Point(mousePos.x - r.x, mousePos.y - r.y);
    }

    public Rectangle getMouseCellRect() {
        Point mousePos = this.getMousePosition();
        if (mousePos == null) {
            return null;
        }
        int row = this.getRowForLocation(mousePos.x, mousePos.y);
        if (row == -1) {
            return null;
        }
        Rectangle r = this.getRowBounds(row);
        return r;
    }

    public void setLinkedObject(OWLObject object) {
        this.linkedObject = object;
    }

    public void setDrawNodeSeperators(boolean drawNodeSeperators) {
        this.drawNodeSeperators = drawNodeSeperators;
    }
}

