/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.tree;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProviderListener;
import org.protege.editor.owl.ui.transfer.OWLObjectDragSource;
import org.protege.editor.owl.ui.transfer.OWLObjectDropTarget;
import org.protege.editor.owl.ui.transfer.OWLObjectTreeDragGestureListener;
import org.protege.editor.owl.ui.transfer.OWLObjectTreeDropTargetListener;
import org.protege.editor.owl.ui.tree.OWLObjectTreeNode;
import org.protege.editor.owl.ui.tree.OWLObjectTreeRootNode;
import org.protege.editor.owl.ui.tree.OWLTreeDragAndDropHandler;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectTree<N extends OWLObject>
extends JTree
implements OWLObjectDropTarget,
OWLObjectDragSource {
    private Map<OWLObject, Set<OWLObjectTreeNode<N>>> nodeMap;
    private OWLEditorKit eKit;
    private OWLObjectHierarchyProvider<N> provider;
    private OWLObjectHierarchyProviderListener<N> listener;
    private Comparator<OWLObject> comparator;
    private OWLTreeDragAndDropHandler<N> dragAndDropHandler;
    private boolean dragOriginator;
    private boolean menuShortCutKeyDown;
    private Point mouseDownPos;
    private int dropRow = -1;
    private Timer expandNodeTimer = new Timer(800, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (OWLObjectTree.this.dropRow != -1) {
                TreePath path = OWLObjectTree.this.getPathForRow(OWLObjectTree.this.dropRow);
                OWLObjectTree.this.expandPath(path);
                OWLObjectTree.this.expandNodeTimer.stop();
            }
        }
    });
    private Stroke s = new BasicStroke(2.0f);

    public OWLObjectTree(OWLEditorKit eKit, OWLObjectHierarchyProvider<N> provider) {
        this(eKit, provider, null);
    }

    public OWLObjectTree(OWLEditorKit eKit, OWLObjectHierarchyProvider<N> provider, Comparator<OWLObject> objectComparator) {
        this(eKit, provider, provider.getRoots(), objectComparator);
    }

    public OWLObjectTree(OWLEditorKit eKit, OWLObjectHierarchyProvider<N> provider, Set<N> rootObjects, Comparator<OWLObject> owlObjectComparator) {
        this.eKit = eKit;
        ToolTipManager.sharedInstance().registerComponent(this);
        this.comparator = owlObjectComparator;
        this.provider = provider;
        this.nodeMap = new HashMap<OWLObject, Set<OWLObjectTreeNode<N>>>();
        this.listener = new OWLObjectHierarchyProviderListener<N>(){

            @Override
            public void hierarchyChanged() {
                OWLObjectTree.this.reload();
            }

            @Override
            public void nodeChanged(N node) {
                OWLObjectTree.this.updateNode(node);
            }
        };
        provider.addListener(this.listener);
        this.setModel(new DefaultTreeModel(new OWLObjectTreeRootNode<N>(this, rootObjects)));
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.setRowHeight(18);
        this.setScrollsOnExpand(true);
        this.setAutoscrolls(true);
        this.setExpandsSelectedPaths(true);
        DropTarget dt = new DropTarget(this, new OWLObjectTreeDropTargetListener(this));
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, new OWLObjectTreeDragGestureListener(eKit, this));
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 3 && e.isControlDown() && e.isShiftDown()) {
                    OWLObjectTree.this.reload();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                OWLObjectTree.this.menuShortCutKeyDown = (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                OWLObjectTree.this.handleExpansionEvent(event);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                OWLObjectTree.this.scrollPathToVisible(event.getNewLeadSelectionPath());
            }
        });
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        N obj = this.getOWLObjectAtMousePosition(event);
        if (obj instanceof OWLEntity) {
            return ((OWLEntity)obj).getIRI().toString();
        }
        return null;
    }

    private void updateNode(N node) {
        Set<OWLObjectTreeNode<N>> treeNodes = this.nodeMap.get(node);
        if (treeNodes != null) {
            Set<N> children = this.provider.getChildren(node);
            HashSet<OWLObjectTreeNode> nodesToRemove = new HashSet<OWLObjectTreeNode>();
            for (OWLObjectTreeNode<N> oWLObjectTreeNode : treeNodes) {
                for (int i = 0; i < oWLObjectTreeNode.getChildCount(); ++i) {
                    OWLObjectTreeNode childTreeNode = (OWLObjectTreeNode)oWLObjectTreeNode.getChildAt(i);
                    if (children.contains(childTreeNode.getOWLObject())) continue;
                    nodesToRemove.add(childTreeNode);
                }
            }
            for (OWLObjectTreeNode<Object> oWLObjectTreeNode : nodesToRemove) {
                Set<OWLObjectTreeNode<N>> childNodes = this.getNodes((OWLObject)oWLObjectTreeNode.getOWLObject());
                HashSet<OWLObjectTreeNode<N>> updatedChildNodes = new HashSet<OWLObjectTreeNode<N>>();
                for (OWLObjectTreeNode<N> childNode : childNodes) {
                    if (treeNodes.contains(childNode.getParent())) continue;
                    updatedChildNodes.add(childNode);
                }
                this.nodeMap.put((OWLObject)oWLObjectTreeNode.getOWLObject(), updatedChildNodes);
                ((DefaultTreeModel)this.getModel()).removeNodeFromParent(oWLObjectTreeNode);
            }
            HashSet existingChildren = new HashSet();
            for (OWLObjectTreeNode<N> treeNode : treeNodes) {
                for (int i = 0; i < treeNode.getChildCount(); ++i) {
                    existingChildren.add(((OWLObjectTreeNode)treeNode.getChildAt(i)).getOWLObject());
                }
            }
            for (OWLObjectTreeNode<N> treeNode : treeNodes) {
                for (OWLObject child : children) {
                    if (existingChildren.contains(child)) continue;
                    OWLObjectTreeNode<OWLObject> childTreeNode = this.createTreeNode(child);
                    ((DefaultTreeModel)this.getModel()).insertNodeInto(childTreeNode, treeNode, 0);
                }
            }
            if (this.provider.getRoots().contains(node)) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    OWLObjectTreeNode objectTreeNode = (OWLObjectTreeNode)defaultMutableTreeNode.getChildAt(i);
                    if (!objectTreeNode.getOWLObject().equals(node)) continue;
                    return;
                }
                ((DefaultTreeModel)this.getModel()).insertNodeInto(this.createTreeNode(node), defaultMutableTreeNode, 0);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    OWLObjectTreeNode objectTreeNode = (OWLObjectTreeNode)defaultMutableTreeNode.getChildAt(i);
                    if (!objectTreeNode.getOWLObject().equals(node)) continue;
                    ((DefaultTreeModel)this.getModel()).removeNodeFromParent(objectTreeNode);
                    return;
                }
            }
        } else if (this.provider.getRoots().contains(node)) {
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.getModel().getRoot();
            OWLObjectTreeNode<N> nn = this.createTreeNode(node);
            ((DefaultTreeModel)this.getModel()).insertNodeInto(nn, rootNode, 0);
            this.expandPath(new TreePath(rootNode.getPath()));
        }
    }

    public void dispose() {
        this.provider.removeListener(this.listener);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight() + 4);
    }

    public void reload() {
        this.nodeMap.clear();
        Set<N> roots = this.provider.getRoots();
        OWLObjectTreeRootNode<N> rootNode = new OWLObjectTreeRootNode<N>(this, roots);
        ((DefaultTreeModel)this.getModel()).setRoot(rootNode);
    }

    private void handleExpansionEvent(TreeExpansionEvent event) {
        if (this.menuShortCutKeyDown) {
            for (int i = 0; i < this.getModel().getChildCount(event.getPath().getLastPathComponent()); ++i) {
                Object curChild = this.getModel().getChild(event.getPath().getLastPathComponent(), i);
                TreePath path = event.getPath().pathByAddingChild(curChild);
                this.expandPath(path);
            }
        }
    }

    public void setDragAndDropHandler(OWLTreeDragAndDropHandler<N> dragAndDropHandler) {
        this.dragAndDropHandler = dragAndDropHandler;
    }

    public OWLObjectHierarchyProvider<N> getProvider() {
        return this.provider;
    }

    public Comparator<OWLObject> getOWLObjectComparator() {
        return this.comparator != null ? this.comparator : this.eKit.getOWLModelManager().getOWLObjectComparator();
    }

    public void setOWLObjectComparator(Comparator<OWLObject> owlObjectComparator) {
        this.comparator = owlObjectComparator;
        this.reload();
    }

    protected List<OWLObjectTreeNode<N>> getChildNodes(OWLObjectTreeNode<N> parent) {
        ArrayList<OWLObjectTreeNode<N>> result = new ArrayList<OWLObjectTreeNode<N>>();
        Set<N> parentObjects = this.getParentObjectsForNode(parent);
        ArrayList<N> children = new ArrayList<N>(this.provider.getChildren(parent.getOWLObject()));
        if (this.comparator != null) {
            Collections.sort(children, this.comparator);
        }
        for (OWLObject child : children) {
            if (parentObjects.contains(child)) continue;
            result.add(this.createTreeNode(child));
        }
        return result;
    }

    private Set<N> getParentObjectsForNode(OWLObjectTreeNode<N> node) {
        HashSet parentObjects = new HashSet();
        OWLObjectTreeNode parentNode = node;
        while ((parentNode = (OWLObjectTreeNode)parentNode.getParent()) != null) {
            if (parentNode.getOWLObject() == null) continue;
            parentObjects.add(parentNode.getOWLObject());
        }
        return parentObjects;
    }

    protected int getChildCount(N owlObject) {
        if (owlObject == null) {
            return this.provider.getRoots().size();
        }
        return this.provider.getChildren(owlObject).size();
    }

    protected Set<OWLObjectTreeNode<N>> getNodes(OWLObject n) {
        Set<OWLObjectTreeNode<N>> nodes = this.nodeMap.get(n);
        if (nodes == null) {
            nodes = new HashSet<OWLObjectTreeNode<N>>();
            this.nodeMap.put(n, nodes);
        }
        return nodes;
    }

    protected OWLObjectTreeNode<N> createTreeNode(N owlObject) {
        OWLObjectTreeNode<OWLObject> treeNode = new OWLObjectTreeNode<OWLObject>(owlObject, this);
        for (OWLObject equiv : this.provider.getEquivalents(owlObject)) {
            treeNode.addEquivalentObject(equiv);
        }
        this.getNodes((OWLObject)owlObject).add(treeNode);
        return treeNode;
    }

    public void setSelectedOWLObject(N selObject) {
        this.setSelectedOWLObject(selObject, false);
    }

    public void setSelectedOWLObject(N selObject, boolean selectAll) {
        if (selObject == null) {
            return;
        }
        this.setSelectedOWLObjects(Collections.singleton(selObject), selectAll);
    }

    public void setSelectedOWLObjects(Set<N> owlObjects) {
        this.setSelectedOWLObjects(owlObjects, false);
    }

    public void setSelectedOWLObjects(Set<N> owlObjects, boolean selectAll) {
        if (!((Object)this.getSelectedOWLObjects()).equals(owlObjects)) {
            this.clearSelection();
            if (!owlObjects.isEmpty()) {
                final ArrayList<TreePath> paths = new ArrayList<TreePath>();
                for (OWLObject obj : owlObjects) {
                    Set<OWLObjectTreeNode<N>> nodes = this.getNodes(obj);
                    if (nodes.isEmpty()) {
                        this.expandAndSelectPaths(obj, selectAll);
                    }
                    paths.addAll(this.getPaths(obj, selectAll));
                }
                if (!paths.isEmpty()) {
                    this.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            OWLObjectTree.this.scrollPathToVisible((TreePath)paths.get(0));
                        }
                    });
                }
            }
        }
    }

    private List<TreePath> getPaths(N selObject, boolean selectAll) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        Set<OWLObjectTreeNode<N>> nodes = this.getNodes((OWLObject)selObject);
        for (OWLObjectTreeNode<N> node : nodes) {
            paths.add(new TreePath(node.getPath()));
            if (selectAll) continue;
            break;
        }
        return paths;
    }

    private void expandAndSelectPaths(N obj, boolean selectAll) {
        for (List<N> objPath : this.provider.getPathsToRoot(obj)) {
            this.expandAndSelectPath(objPath);
            if (selectAll) continue;
            break;
        }
    }

    private void expandAndSelectPath(List<N> objectPath) {
        Set<OWLObjectTreeNode<N>> nodes;
        int index = 0;
        for (int i = objectPath.size() - 1; i > -1; --i) {
            index = i;
            OWLObject curObj = (OWLObject)objectPath.get(i);
            if (!this.getNodes(curObj).isEmpty()) break;
        }
        if ((nodes = this.getNodes((OWLObject)objectPath.get(index))).isEmpty()) {
            return;
        }
        OWLObjectTreeNode curParNode = nodes.iterator().next();
        block1: for (int i = index + 1; i < objectPath.size(); ++i) {
            this.expandPath(new TreePath(curParNode.getPath()));
            for (int j = 0; j < curParNode.getChildCount(); ++j) {
                OWLObjectTreeNode curChild = (OWLObjectTreeNode)curParNode.getChildAt(j);
                if (!curChild.getOWLObject().equals(objectPath.get(i))) continue;
                curParNode = curChild;
                continue block1;
            }
        }
    }

    public N getSelectedOWLObject() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return ((OWLObjectTreeNode)path.getLastPathComponent()).getOWLObject();
    }

    public List<N> getSelectedOWLObjects() {
        ArrayList selObjects = new ArrayList();
        TreePath[] selPaths = this.getSelectionPaths();
        if (selPaths != null) {
            for (TreePath path : selPaths) {
                selObjects.add(((OWLObjectTreeNode)path.getLastPathComponent()).getOWLObject());
            }
        }
        return selObjects;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setDragOriginater(boolean b) {
        this.dragOriginator = b;
    }

    @Override
    public boolean dropOWLObjects(List<OWLObject> owlObjects, Point pt, int type) {
        if (this.dragAndDropHandler == null) {
            return false;
        }
        TreePath dropPath = this.getPathForLocation(pt.x, pt.y);
        if (dropPath == null) {
            return false;
        }
        Object dropTargetObj = ((OWLObjectTreeNode)dropPath.getLastPathComponent()).getOWLObject();
        final HashSet<OWLObject> droppedObjects = new HashSet<OWLObject>();
        for (OWLObject owlObject : owlObjects) {
            if (dropTargetObj.equals(owlObject) || !this.dragAndDropHandler.canDrop(owlObject, dropTargetObj)) continue;
            OWLObject dropObject = owlObject;
            droppedObjects.add(dropObject);
            TreePath selPath = this.getSelectionPath();
            Object selObj = null;
            Object selObjParent = null;
            if (selPath != null) {
                OWLObjectTreeNode selNode = (OWLObjectTreeNode)selPath.getLastPathComponent();
                selObj = selNode.getOWLObject();
                OWLObjectTreeNode parentNode = (OWLObjectTreeNode)selNode.getParent();
                if (parentNode != null) {
                    selObjParent = parentNode.getOWLObject();
                }
            }
            if (selObj == null) {
                this.dragAndDropHandler.add(dropObject, (OWLObject)dropTargetObj);
                continue;
            }
            if (selObj.equals(owlObject)) {
                if (selObjParent != null) {
                    this.dragAndDropHandler.move(dropObject, (OWLObject)selObjParent, (OWLObject)dropTargetObj);
                    continue;
                }
                this.dragAndDropHandler.add(dropObject, (OWLObject)dropTargetObj);
                continue;
            }
            this.dragAndDropHandler.add(dropObject, (OWLObject)dropTargetObj);
        }
        if (droppedObjects.isEmpty()) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HashSet<OWLObject> nodes = new HashSet<OWLObject>();
                for (OWLObject droppedObject : droppedObjects) {
                    if (OWLObjectTree.this.getNodes(droppedObject) == null) continue;
                    nodes.add(droppedObject);
                }
                OWLObjectTree.this.setSelectedOWLObjects(nodes);
            }
        });
        return true;
    }

    @Override
    public OWLModelManager getOWLModelManager() {
        return this.eKit.getModelManager();
    }

    public int getDropRow() {
        return this.dropRow;
    }

    public void setDropRow(int dropRow) {
        Rectangle r;
        this.expandNodeTimer.restart();
        if (this.dropRow != -1) {
            r = this.getDropRowBounds();
            if (r != null) {
                this.repaint(r);
            }
            this.expandNodeTimer.stop();
        }
        this.dropRow = dropRow;
        if (this.dropRow != -1) {
            r = this.getDropRowBounds();
            if (r != null) {
                this.repaint(r);
            }
            this.expandNodeTimer.start();
            this.scrollRowToVisible(dropRow);
        }
    }

    public Rectangle getDropRowBounds() {
        Rectangle r = this.getRowBounds(this.dropRow);
        if (r == null) {
            return null;
        }
        r.x -= 2;
        r.y -= 2;
        r.width += 4;
        r.height += 4;
        return r;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.dropRow != -1) {
            Rectangle r = this.getRowBounds(this.dropRow);
            if (r == null) {
                return;
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).setStroke(this.s);
            Color color = UIManager.getDefaults().getColor("Tree.selectionBorderColor");
            g.setColor(color);
            g.drawRoundRect(r.x, r.y, r.width, r.height, 7, 7);
        }
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandPath(this.getPathForRow(i));
        }
    }

    protected N getOWLObjectAtMousePosition(MouseEvent event) {
        Point pt = event.getPoint();
        TreePath path = this.getPathForLocation(pt.x, pt.y);
        if (path == null) {
            return null;
        }
        OWLObjectTreeNode node = (OWLObjectTreeNode)path.getLastPathComponent();
        return node.getOWLObject();
    }
}

