/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.protege.editor.owl.ui.tree.OWLObjectTree;
import org.protege.editor.owl.ui.tree.OWLObjectTreeNode;
import org.semanticweb.owlapi.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectTreeRootNode<N extends OWLObject>
extends OWLObjectTreeNode<N> {
    public static final Object ROOT_OBJECT = "ROOT";
    private OWLObjectTree<N> tree;
    private Set<N> roots;

    public OWLObjectTreeRootNode(OWLObjectTree<N> tree, Set<N> roots) {
        super(tree);
        this.tree = tree;
        this.roots = roots;
    }

    @Override
    protected void loadChildrenIfNecessary() {
        if (this.isLoaded()) {
            return;
        }
        this.setLoaded(true);
        ArrayList<N> sortedRoots = new ArrayList<N>(this.roots);
        if (this.tree.getOWLObjectComparator() != null) {
            Collections.sort(sortedRoots, this.tree.getOWLObjectComparator());
        }
        for (OWLObject root : sortedRoots) {
            this.add(this.tree.createTreeNode(root));
        }
    }
}

