/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.tree;

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.protege.editor.core.ui.preferences.PreferencesPanelLayoutManager;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import org.protege.editor.owl.ui.tree.OWLTreePreferences;

public class OWLTreePreferencesPanel
extends OWLPreferencesPanel {
    private JCheckBox autoExpandEnabledCheckBox;
    private JSpinner autoExpandMaxDepthSpinner;
    private JSpinner autoExpandMaxChildSizeSpinner;

    public void initialise() throws Exception {
        OWLTreePreferences prefs = OWLTreePreferences.getInstance();
        this.autoExpandEnabledCheckBox = new JCheckBox("Automatically expand hierarchies", prefs.isAutoExpandEnabled());
        this.autoExpandMaxDepthSpinner = new JSpinner(new SpinnerNumberModel(prefs.getAutoExpansionDepthLimit(), 1, Integer.MAX_VALUE, 1));
        this.autoExpandMaxChildSizeSpinner = new JSpinner(new SpinnerNumberModel(prefs.getAutoExpansionChildLimit(), 1, Integer.MAX_VALUE, 1));
        JPanel autoExpansionPanel = new JPanel();
        PreferencesPanelLayoutManager layout = new PreferencesPanelLayoutManager((JComponent)autoExpansionPanel);
        autoExpansionPanel.setLayout((LayoutManager)layout);
        autoExpansionPanel.add("", this.autoExpandEnabledCheckBox);
        autoExpansionPanel.add("Auto-expansion depth limit", this.autoExpandMaxDepthSpinner);
        autoExpansionPanel.add("Auto-expansion child count limit", this.autoExpandMaxChildSizeSpinner);
        autoExpansionPanel.setBorder(ComponentFactory.createTitledBorder((String)"Automatic Hierarchy Expansion"));
        this.setLayout(new BorderLayout());
        this.add(autoExpansionPanel, "Center");
    }

    public void applyChanges() {
        OWLTreePreferences prefs = OWLTreePreferences.getInstance();
        prefs.setAutoExpansionEnabled(this.autoExpandEnabledCheckBox.isSelected());
        prefs.setAutoExpansionDepthLimit((Integer)this.autoExpandMaxDepthSpinner.getValue());
        prefs.setAutoExpansionChildLimit((Integer)this.autoExpandMaxChildSizeSpinner.getValue());
    }

    public void dispose() throws Exception {
    }
}

