/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.usage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.usage.UsageFilter;
import org.protege.editor.owl.ui.usage.UsageTreeModel;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitor;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageByEntityTreeModel
extends DefaultTreeModel
implements UsageTreeModel {
    private static final long serialVersionUID = -2530774548488512609L;
    private OWLModelManager owlModelManager;
    private DefaultMutableTreeNode rootNode;
    private AxiomSorter axiomSorter;
    private OWLOntology currentOntology;
    private Map<OWLEntity, DefaultMutableTreeNode> nodeMap;
    private OWLEntity entity;
    private Map<OWLEntity, Set<OWLAxiom>> axiomsByEntityMap;
    private Set<OWLAxiom> additionalAxioms = new HashSet<OWLAxiom>();
    private int usageCount;
    private Set<UsageFilter> filters = new HashSet<UsageFilter>();

    public UsageByEntityTreeModel(OWLEditorKit owlEditorKit) {
        super(new DefaultMutableTreeNode("No usage"));
        this.owlModelManager = owlEditorKit.getModelManager();
        this.axiomSorter = new AxiomSorter();
        this.nodeMap = new HashMap<OWLEntity, DefaultMutableTreeNode>();
        this.axiomsByEntityMap = new TreeMap<OWLObject, Set<OWLAxiom>>(this.owlModelManager.getOWLObjectComparator());
    }

    public UsageByEntityTreeModel(OWLEditorKit owlEditorKit, OWLEntity entity) {
        this(owlEditorKit);
        this.setOWLEntity(entity);
    }

    private String getRootContent(OWLModelManager mngr, OWLEntity entity) {
        return entity != null ? "Found " + this.usageCount + " uses of " + mngr.getRendering((OWLObject)entity) : "";
    }

    @Override
    public void setOWLEntity(OWLEntity owlEntity) {
        this.entity = owlEntity;
        this.axiomsByEntityMap.clear();
        this.usageCount = 0;
        Iterator<OWLOntology> i$ = this.owlModelManager.getActiveOntologies().iterator();
        while (i$.hasNext()) {
            OWLOntology ont;
            this.currentOntology = ont = i$.next();
            Set axioms = ont.getReferencingAxioms(owlEntity);
            for (OWLAxiom ax : axioms) {
                this.axiomSorter.setAxiom(ax);
                ax.accept((OWLAxiomVisitor)this.axiomSorter);
            }
        }
        this.rootNode = new DefaultMutableTreeNode(this.getRootContent(this.owlModelManager, this.entity));
        this.setRoot(this.rootNode);
        for (OWLEntity ent : this.axiomsByEntityMap.keySet()) {
            for (OWLAxiom ax : this.axiomsByEntityMap.get(ent)) {
                this.getNode(ent).add(new UsageTreeNode(null, ax));
            }
        }
        if (!this.additionalAxioms.isEmpty()) {
            DefaultMutableTreeNode otherNode = new DefaultMutableTreeNode("Other");
            this.rootNode.add(otherNode);
            for (OWLAxiom ax : this.additionalAxioms) {
                otherNode.add(new DefaultMutableTreeNode(ax));
            }
        }
    }

    @Override
    public void addFilter(UsageFilter filter) {
        this.filters.add(filter);
    }

    @Override
    public void addFilters(Set<UsageFilter> filters) {
        this.filters.addAll(filters);
    }

    @Override
    public void removeFilter(UsageFilter filter) {
        this.filters.remove((Object)filter);
    }

    private boolean isFilterSet(UsageFilter filter) {
        return this.filters.contains((Object)filter);
    }

    private DefaultMutableTreeNode getNode(OWLEntity entity) {
        DefaultMutableTreeNode node = this.nodeMap.get(entity);
        if (node == null) {
            node = new DefaultMutableTreeNode(entity);
            this.nodeMap.put(entity, node);
            this.rootNode.add(node);
        }
        return node;
    }

    @Override
    public void refresh() {
        this.setOWLEntity(this.entity);
    }

    protected class UsageTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -53617232488795863L;
        private OWLOntology ont;
        private OWLAxiom axiom;

        public UsageTreeNode(OWLOntology ont, OWLAxiom axiom) {
            super(axiom);
            this.ont = ont;
            this.axiom = axiom;
        }

        public OWLAxiom getAxiom() {
            return this.axiom;
        }

        public OWLOntology getOntology() {
            return this.ont;
        }
    }

    private class AxiomSorter
    implements OWLAxiomVisitor,
    OWLEntityVisitor,
    OWLPropertyExpressionVisitor {
        private OWLAxiom currentAxiom;

        private AxiomSorter() {
        }

        public void setAxiom(OWLAxiom axiom) {
            this.currentAxiom = axiom;
        }

        private void add(OWLEntity ent) {
            if (UsageByEntityTreeModel.this.isFilterSet(UsageFilter.filterSelf) && UsageByEntityTreeModel.this.entity.equals(ent)) {
                return;
            }
            UsageByEntityTreeModel.this.usageCount++;
            HashSet<OWLAxiom> axioms = (HashSet<OWLAxiom>)UsageByEntityTreeModel.this.axiomsByEntityMap.get(ent);
            if (axioms == null) {
                axioms = new HashSet<OWLAxiom>();
                UsageByEntityTreeModel.this.axiomsByEntityMap.put(ent, axioms);
            }
            axioms.add(this.currentAxiom);
        }

        public void visit(OWLClass cls) {
            this.add((OWLEntity)cls);
        }

        public void visit(OWLDatatype dataType) {
            this.add((OWLEntity)dataType);
        }

        public void visit(OWLNamedIndividual individual) {
            this.add((OWLEntity)individual);
        }

        public void visit(OWLDataProperty property) {
            this.add((OWLEntity)property);
        }

        public void visit(OWLObjectProperty property) {
            this.add((OWLEntity)property);
        }

        public void visit(OWLAnnotationProperty property) {
            this.add((OWLEntity)property);
        }

        public void visit(OWLObjectInverseOf property) {
            property.getInverse().accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            if (axiom.getSubject() instanceof IRI) {
                IRI subjectIRI = (IRI)axiom.getSubject();
                for (OWLOntology ont : UsageByEntityTreeModel.this.owlModelManager.getActiveOntologies()) {
                    if (ont.containsClassInSignature(subjectIRI)) {
                        this.add((OWLEntity)UsageByEntityTreeModel.this.owlModelManager.getOWLDataFactory().getOWLClass(subjectIRI));
                    }
                    if (ont.containsObjectPropertyInSignature(subjectIRI)) {
                        this.add((OWLEntity)UsageByEntityTreeModel.this.owlModelManager.getOWLDataFactory().getOWLObjectProperty(subjectIRI));
                    }
                    if (ont.containsDataPropertyInSignature(subjectIRI)) {
                        this.add((OWLEntity)UsageByEntityTreeModel.this.owlModelManager.getOWLDataFactory().getOWLDataProperty(subjectIRI));
                    }
                    if (ont.containsIndividualInSignature(subjectIRI)) {
                        this.add((OWLEntity)UsageByEntityTreeModel.this.owlModelManager.getOWLDataFactory().getOWLNamedIndividual(subjectIRI));
                    }
                    if (ont.containsAnnotationPropertyInSignature(subjectIRI)) {
                        this.add((OWLEntity)UsageByEntityTreeModel.this.owlModelManager.getOWLDataFactory().getOWLAnnotationProperty(subjectIRI));
                    }
                    if (!ont.containsDatatypeInSignature(subjectIRI)) continue;
                    this.add((OWLEntity)UsageByEntityTreeModel.this.owlModelManager.getOWLDataFactory().getOWLDatatype(subjectIRI));
                }
            }
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            axiom.getSubProperty().accept((OWLEntityVisitor)this);
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
            axiom.getProperty().accept((OWLEntityVisitor)this);
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
            axiom.getProperty().accept((OWLEntityVisitor)this);
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            if (!axiom.getIndividual().isAnonymous()) {
                axiom.getIndividual().asOWLNamedIndividual().accept((OWLEntityVisitor)this);
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            if (!axiom.getSubject().isAnonymous()) {
                axiom.getSubject().asOWLNamedIndividual().accept((OWLEntityVisitor)this);
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            ((OWLDataPropertyExpression)axiom.getSubProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLDeclarationAxiom axiom) {
            axiom.getEntity().accept((OWLEntityVisitor)this);
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                if (ind.isAnonymous()) continue;
                ind.asOWLNamedIndividual().accept((OWLEntityVisitor)this);
            }
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            boolean hasBeenIndexed = false;
            if (!UsageByEntityTreeModel.this.isFilterSet(UsageFilter.filterDisjoints)) {
                for (OWLClassExpression desc : axiom.getClassExpressions()) {
                    if (desc.isAnonymous()) continue;
                    desc.asOWLClass().accept((OWLEntityVisitor)this);
                    hasBeenIndexed = true;
                }
            }
            if (!hasBeenIndexed) {
                UsageByEntityTreeModel.this.additionalAxioms.add(axiom);
                UsageByEntityTreeModel.this.usageCount++;
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            if (!UsageByEntityTreeModel.this.isFilterSet(UsageFilter.filterDisjoints)) {
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    prop.accept((OWLPropertyExpressionVisitor)this);
                }
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            if (!UsageByEntityTreeModel.this.isFilterSet(UsageFilter.filterDisjoints)) {
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    prop.accept((OWLPropertyExpressionVisitor)this);
                }
            }
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            if (!UsageByEntityTreeModel.this.isFilterSet(UsageFilter.filterDisjoints)) {
                axiom.getOWLClass().accept((OWLEntityVisitor)this);
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            boolean hasBeenIndexed = false;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                desc.asOWLClass().accept((OWLEntityVisitor)this);
                hasBeenIndexed = true;
            }
            if (!hasBeenIndexed) {
                UsageByEntityTreeModel.this.additionalAxioms.add(axiom);
                UsageByEntityTreeModel.this.usageCount++;
            }
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                prop.accept((OWLPropertyExpressionVisitor)this);
            }
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                prop.accept((OWLPropertyExpressionVisitor)this);
            }
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                prop.accept((OWLPropertyExpressionVisitor)this);
            }
        }

        public void visit(OWLHasKeyAxiom axiom) {
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            axiom.getDatatype().accept((OWLEntityVisitor)this);
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            if (!axiom.getSubject().isAnonymous()) {
                axiom.getSubject().asOWLNamedIndividual().accept((OWLEntityVisitor)this);
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            if (!axiom.getSubject().isAnonymous()) {
                axiom.getSubject().asOWLNamedIndividual().accept((OWLEntityVisitor)this);
            }
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            if (!axiom.getSubject().isAnonymous()) {
                axiom.getSubject().asOWLNamedIndividual().accept((OWLEntityVisitor)this);
            }
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            axiom.getSuperProperty().accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                if (ind.isAnonymous()) continue;
                ind.asOWLNamedIndividual().accept((OWLEntityVisitor)this);
            }
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                if (!UsageByEntityTreeModel.this.isFilterSet(UsageFilter.filterNamedSubsSupers) || !axiom.getSubClass().equals(UsageByEntityTreeModel.this.entity) && !axiom.getSuperClass().equals(UsageByEntityTreeModel.this.entity)) {
                    axiom.getSubClass().asOWLClass().accept((OWLEntityVisitor)this);
                }
            } else {
                UsageByEntityTreeModel.this.additionalAxioms.add(axiom);
                UsageByEntityTreeModel.this.usageCount++;
            }
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLPropertyExpressionVisitor)this);
        }

        public void visit(SWRLRule rule) {
        }
    }
}

