/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.usage;

import java.util.HashSet;
import java.util.Set;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.owl.ui.usage.UsageFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsagePreferences {
    private static UsagePreferences instance;

    public static UsagePreferences getInstance() {
        if (instance == null) {
            instance = new UsagePreferences();
        }
        return instance;
    }

    private Preferences getPreferences() {
        return PreferencesManager.getInstance().getApplicationPreferences(this.getClass());
    }

    public boolean isFilterActive(UsageFilter filter) {
        return this.getPreferences().getBoolean(filter.getKey(), false);
    }

    public void setFilterActive(UsageFilter filter, boolean active) {
        this.getPreferences().putBoolean(filter.getKey(), active);
    }

    public Set<UsageFilter> getActiveFilters() {
        HashSet<UsageFilter> activeFilters = new HashSet<UsageFilter>();
        for (UsageFilter filter : UsageFilter.values()) {
            if (!this.isFilterActive(filter)) continue;
            activeFilters.add(filter);
        }
        return activeFilters;
    }
}

