/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.usage;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.tree.OWLLinkedObjectTree;
import org.protege.editor.owl.ui.usage.UsageByEntityTreeModel;
import org.protege.editor.owl.ui.usage.UsagePreferences;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;

public class UsageTree
extends OWLLinkedObjectTree {
    private static final long serialVersionUID = 2978742855867968571L;
    private OWLEditorKit owlEditorKit;
    private OWLEntity entity;

    public UsageTree(OWLEditorKit owlEditorKit) {
        super(owlEditorKit);
        this.owlEditorKit = owlEditorKit;
        this.setCellRenderer(new UsageTreeCellRenderer(owlEditorKit));
    }

    public void setOWLEntity(OWLEntity entity) {
        this.entity = entity;
        UsagePreferences p = UsagePreferences.getInstance();
        UsageByEntityTreeModel model = new UsageByEntityTreeModel(this.owlEditorKit);
        model.addFilters(p.getActiveFilters());
        model.setOWLEntity(entity);
        this.setModel(model);
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
            if (i > 100) break;
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        g.setColor(Color.LIGHT_GRAY);
        for (int i = 0; i < this.getRowCount(); ++i) {
            Rectangle rowBounds = this.getRowBounds(i);
            if (!g.getClipBounds().intersects(rowBounds) || this.getPathForRow(i).getPathCount() != 2) continue;
            g.drawLine(0, rowBounds.y, this.getWidth(), rowBounds.y);
        }
        g.setColor(oldColor);
    }

    private class UsageTreeCellRenderer
    extends OWLCellRenderer {
        public UsageTreeCellRenderer(OWLEditorKit owlEditorKit) {
            super(owlEditorKit);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            this.setFocusedEntity(UsageTree.this.entity);
            JComponent c = (JComponent)super.getTreeCellRendererComponent(tree, node.getUserObject(), sel, expanded, leaf, row, hasFocus);
            if (node.getUserObject() instanceof OWLAxiom) {
                if (node.getParent().getIndex(node) == node.getParent().getChildCount() - 1) {
                    c.setBorder(BorderFactory.createMatteBorder(1, 20, 20, 0, tree.getBackground()));
                } else {
                    c.setBorder(BorderFactory.createMatteBorder(1, 20, 0, 0, tree.getBackground()));
                }
            } else {
                c.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
            }
            this.setHighlightKeywords(true);
            return c;
        }
    }
}

