/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.frame.InferredAxiomsFrame;
import org.protege.editor.owl.ui.framelist.OWLFrameList;
import org.protege.editor.owl.ui.view.AbstractActiveOntologyViewComponent;
import org.semanticweb.owlapi.model.OWLOntology;

public class InferredAxiomsViewComponent
extends AbstractActiveOntologyViewComponent {
    private static final long serialVersionUID = 7129182885438253297L;
    private InferredAxiomsFrame frame;
    private OWLFrameList<OWLOntology> frameList;
    private OWLModelManagerListener listener = new OWLModelManagerListener(){

        public void handleChange(OWLModelManagerChangeEvent event) {
            if (event.isType(EventType.ONTOLOGY_CLASSIFIED) && InferredAxiomsViewComponent.this.isSynchronizing()) {
                try {
                    InferredAxiomsViewComponent.this.updateView(InferredAxiomsViewComponent.this.getOWLModelManager().getActiveOntology());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    };

    protected void initialiseOntologyView() throws Exception {
        this.setLayout(new BorderLayout());
        this.frame = new InferredAxiomsFrame(this.getOWLEditorKit());
        this.frameList = new OWLFrameList<OWLOntology>(this.getOWLEditorKit(), this.frame);
        this.frameList.setRootObject(this.getOWLModelManager().getActiveOntology());
        this.updateHeader();
        this.add(new JScrollPane((Component)((Object)this.frameList)));
        this.getOWLModelManager().addListener(this.listener);
    }

    protected void updateView(OWLOntology activeOntology) throws Exception {
        if (this.isSynchronizing()) {
            this.frameList.setRootObject(activeOntology);
            this.updateHeader();
        }
    }

    private void updateHeader() {
        this.getView().setHeaderText("Classified using " + this.getOWLModelManager().getOWLReasonerManager().getCurrentReasonerName());
    }

    protected void disposeOntologyView() {
        this.frameList.dispose();
        this.getOWLModelManager().removeListener(this.listener);
    }
}

