/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.cls;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.action.AbstractOWLTreeAction;
import org.protege.editor.owl.ui.action.DeleteClassAction;
import org.protege.editor.owl.ui.tree.OWLObjectTreeNode;
import org.protege.editor.owl.ui.tree.OWLTreeDragAndDropHandler;
import org.protege.editor.owl.ui.view.CreateNewChildTarget;
import org.protege.editor.owl.ui.view.CreateNewSiblingTarget;
import org.protege.editor.owl.ui.view.CreateNewTarget;
import org.protege.editor.owl.ui.view.cls.AbstractOWLClassHierarchyViewComponent;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLEntitySetProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToldOWLClassHierarchyViewComponent
extends AbstractOWLClassHierarchyViewComponent
implements CreateNewTarget,
CreateNewChildTarget,
CreateNewSiblingTarget {
    private static final long serialVersionUID = 8712815067223088069L;

    @Override
    public void performExtraInitialisation() throws Exception {
        this.addAction(new AbstractOWLTreeAction<OWLClass>("Add subclass", OWLIcons.getIcon("class.add.sub.png"), this.getTree().getSelectionModel()){

            public void actionPerformed(ActionEvent event) {
                ToldOWLClassHierarchyViewComponent.this.createNewChild();
            }

            @Override
            protected boolean canPerform(OWLClass cls) {
                return ToldOWLClassHierarchyViewComponent.this.canCreateNewChild();
            }
        }, "A", "A");
        this.addAction(new AbstractOWLTreeAction<OWLClass>("Add sibling class", OWLIcons.getIcon("class.add.sib.png"), this.getTree().getSelectionModel()){

            public void actionPerformed(ActionEvent event) {
                ToldOWLClassHierarchyViewComponent.this.createNewSibling();
            }

            @Override
            protected boolean canPerform(OWLClass cls) {
                return ToldOWLClassHierarchyViewComponent.this.canCreateNewSibling();
            }
        }, "A", "B");
        this.addAction(new DeleteClassAction(this.getOWLEditorKit(), new OWLEntitySetProvider<OWLClass>(){

            public Set<OWLClass> getEntities() {
                return new HashSet<OWLClass>(ToldOWLClassHierarchyViewComponent.this.getTree().getSelectedOWLObjects());
            }
        }), "B", "A");
        this.getTree().setDragAndDropHandler(new OWLTreeDragAndDropHandler<OWLClass>(){

            @Override
            public boolean canDrop(Object child, Object parent) {
                return child instanceof OWLClass;
            }

            @Override
            public void move(OWLClass child, OWLClass fromParent, OWLClass toParent) {
                ToldOWLClassHierarchyViewComponent.this.handleMove(child, fromParent, toParent);
            }

            @Override
            public void add(OWLClass child, OWLClass parent) {
                ToldOWLClassHierarchyViewComponent.this.handleAdd(child, parent);
            }
        });
    }

    private void handleAdd(OWLClass child, OWLClass parent) {
        if (child.equals(this.getOWLModelManager().getOWLDataFactory().getOWLThing())) {
            return;
        }
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)this.getOWLModelManager().getOWLDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)child, (OWLClassExpression)parent)));
        this.getOWLModelManager().applyChanges(changes);
    }

    private void handleMove(OWLClass child, OWLClass fromParent, OWLClass toParent) {
        OWLDataFactory df = this.getOWLModelManager().getOWLDataFactory();
        if (child.equals(df.getOWLThing())) {
            return;
        }
        ArrayList<Object> changes = new ArrayList<Object>();
        changes.add(new RemoveAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)df.getOWLSubClassOfAxiom((OWLClassExpression)child, (OWLClassExpression)fromParent)));
        changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)df.getOWLSubClassOfAxiom((OWLClassExpression)child, (OWLClassExpression)toParent)));
        this.getOWLModelManager().applyChanges(changes);
    }

    @Override
    protected OWLObjectHierarchyProvider<OWLClass> getHierarchyProvider() {
        return this.getOWLModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider();
    }

    @Override
    public boolean canCreateNew() {
        return true;
    }

    @Override
    public boolean canCreateNewChild() {
        return !this.getSelectedEntities().isEmpty();
    }

    @Override
    public boolean canCreateNewSibling() {
        return !this.getSelectedEntities().isEmpty() && !((OWLClass)this.getSelectedEntity()).equals(this.getOWLModelManager().getOWLDataFactory().getOWLThing());
    }

    @Override
    public void createNewChild() {
        OWLEntityCreationSet<OWLClass> set = this.getOWLWorkspace().createOWLClass();
        if (set != null) {
            OWLClass newClass = set.getOWLEntity();
            OWLClass selectedClass = (OWLClass)this.getSelectedEntity();
            ArrayList<Object> changes = new ArrayList<Object>();
            changes.addAll(set.getOntologyChanges());
            OWLModelManager mngr = this.getOWLEditorKit().getModelManager();
            OWLDataFactory df = mngr.getOWLDataFactory();
            if (!df.getOWLThing().equals(selectedClass)) {
                OWLSubClassOfAxiom ax = df.getOWLSubClassOfAxiom((OWLClassExpression)set.getOWLEntity(), (OWLClassExpression)selectedClass);
                changes.add(new AddAxiom(mngr.getActiveOntology(), (OWLAxiom)ax));
            }
            mngr.applyChanges(changes);
            this.getTree().setSelectedOWLObject(newClass);
        }
    }

    @Override
    public void createNewObject() {
        OWLEntityCreationSet<OWLClass> set = this.getOWLWorkspace().createOWLClass();
        if (set != null) {
            OWLClass newClass = set.getOWLEntity();
            this.getOWLModelManager().applyChanges(set.getOntologyChanges());
            this.getTree().setSelectedOWLObject(newClass);
        }
    }

    @Override
    public void createNewSibling() {
        OWLClass cls = (OWLClass)this.getTree().getSelectedOWLObject();
        if (cls == null) {
            return;
        }
        OWLEntityCreationSet<OWLClass> creationSet = this.getOWLWorkspace().createOWLClass();
        if (creationSet != null) {
            OWLObjectTreeNode parentNode = (OWLObjectTreeNode)this.getTree().getSelectionPath().getParentPath().getLastPathComponent();
            if (parentNode == null || parentNode.getOWLObject() == null) {
                return;
            }
            OWLClass parentCls = (OWLClass)parentNode.getOWLObject();
            ArrayList<Object> changes = new ArrayList<Object>();
            changes.addAll(creationSet.getOntologyChanges());
            OWLModelManager mngr = this.getOWLModelManager();
            OWLDataFactory df = mngr.getOWLDataFactory();
            changes.add(new AddAxiom(mngr.getActiveOntology(), (OWLAxiom)df.getOWLSubClassOfAxiom((OWLClassExpression)creationSet.getOWLEntity(), (OWLClassExpression)parentCls)));
            mngr.applyChanges(changes);
            this.getTree().setSelectedOWLObject(creationSet.getOWLEntity());
        }
    }
}

