/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.individual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.protege.editor.owl.ui.view.individual.OWLIndividualListViewComponent;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLMembersListViewComponent
extends OWLIndividualListViewComponent {
    private static final long serialVersionUID = -6015526995379146198L;
    private OWLSelectionModelListener l = new OWLSelectionModelListener(){

        public void selectionChanged() throws Exception {
            if (OWLMembersListViewComponent.this.getOWLWorkspace().getOWLSelectionModel().getSelectedObject() instanceof OWLClass) {
                OWLMembersListViewComponent.this.refill();
            }
        }
    };

    @Override
    public void initialiseIndividualsView() throws Exception {
        super.initialiseIndividualsView();
        this.getOWLWorkspace().getOWLSelectionModel().addListener(this.l);
    }

    @Override
    protected void refill() {
        this.individualsInList.clear();
        OWLClass cls = this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedClass();
        if (cls != null) {
            Set individuals = cls.getIndividuals(this.getOntologies());
            for (OWLIndividual ind : individuals) {
                if (ind.isAnonymous()) continue;
                this.individualsInList.add(ind.asOWLNamedIndividual());
            }
            if (cls.equals(this.getOWLModelManager().getOWLDataFactory().getOWLThing())) {
                this.individualsInList.addAll(this.getUntypedIndividuals());
            }
        }
        this.reset();
    }

    protected Set<OWLNamedIndividual> getUntypedIndividuals() {
        HashSet<OWLNamedIndividual> untypedIndividuals = new HashSet<OWLNamedIndividual>();
        OWLOntology activeOntology = this.getOWLModelManager().getActiveOntology();
        Set importsClosure = activeOntology.getImportsClosure();
        for (OWLNamedIndividual individual : activeOntology.getIndividualsInSignature(true)) {
            Set types = individual.getTypes(importsClosure);
            if (types != null && types.size() != 0) continue;
            untypedIndividuals.add(individual);
        }
        return untypedIndividuals;
    }

    @Override
    protected void processChanges(List<? extends OWLOntologyChange> changes) {
        this.refill();
    }

    @Override
    protected List<OWLOntologyChange> dofurtherCreateSteps(OWLIndividual newIndividual) {
        OWLClass cls = this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedClass();
        if (cls != null) {
            OWLClassAssertionAxiom typeAxiom = this.getOWLModelManager().getOWLDataFactory().getOWLClassAssertionAxiom((OWLClassExpression)cls, newIndividual);
            AddAxiom change = new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)typeAxiom);
            return Collections.singletonList(change);
        }
        return new ArrayList<OWLOntologyChange>();
    }

    @Override
    public void disposeView() {
        this.getOWLWorkspace().getOWLSelectionModel().removeListener(this.l);
        super.disposeView();
    }
}

